/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.VideoOverlayCrop;
import software.amazon.awssdk.services.mediaconvert.model.VideoOverlayInput;
import software.amazon.awssdk.services.mediaconvert.model.VideoOverlayPlayBackMode;
import software.amazon.awssdk.services.mediaconvert.model.VideoOverlayPosition;
import software.amazon.awssdk.services.mediaconvert.model.VideoOverlayTransition;
import software.amazon.awssdk.services.mediaconvert.model.___listOfVideoOverlayTransitionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoOverlay
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoOverlay> {
    private static final SdkField<VideoOverlayCrop> CROP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Crop").getter(VideoOverlay.getter(VideoOverlay::crop)).setter(VideoOverlay.setter(Builder::crop)).constructor(VideoOverlayCrop::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crop").build()}).build();
    private static final SdkField<String> END_TIMECODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTimecode").getter(VideoOverlay.getter(VideoOverlay::endTimecode)).setter(VideoOverlay.setter(Builder::endTimecode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimecode").build()}).build();
    private static final SdkField<VideoOverlayPosition> INITIAL_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InitialPosition").getter(VideoOverlay.getter(VideoOverlay::initialPosition)).setter(VideoOverlay.setter(Builder::initialPosition)).constructor(VideoOverlayPosition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialPosition").build()}).build();
    private static final SdkField<VideoOverlayInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(VideoOverlay.getter(VideoOverlay::input)).setter(VideoOverlay.setter(Builder::input)).constructor(VideoOverlayInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<String> PLAYBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Playback").getter(VideoOverlay.getter(VideoOverlay::playbackAsString)).setter(VideoOverlay.setter(Builder::playback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playback").build()}).build();
    private static final SdkField<String> START_TIMECODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTimecode").getter(VideoOverlay.getter(VideoOverlay::startTimecode)).setter(VideoOverlay.setter(Builder::startTimecode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimecode").build()}).build();
    private static final SdkField<List<VideoOverlayTransition>> TRANSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Transitions").getter(VideoOverlay.getter(VideoOverlay::transitions)).setter(VideoOverlay.setter(Builder::transitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VideoOverlayTransition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CROP_FIELD, END_TIMECODE_FIELD, INITIAL_POSITION_FIELD, INPUT_FIELD, PLAYBACK_FIELD, START_TIMECODE_FIELD, TRANSITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoOverlay.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VideoOverlayCrop crop;
    private final String endTimecode;
    private final VideoOverlayPosition initialPosition;
    private final VideoOverlayInput input;
    private final String playback;
    private final String startTimecode;
    private final List<VideoOverlayTransition> transitions;

    private VideoOverlay(BuilderImpl builder) {
        this.crop = builder.crop;
        this.endTimecode = builder.endTimecode;
        this.initialPosition = builder.initialPosition;
        this.input = builder.input;
        this.playback = builder.playback;
        this.startTimecode = builder.startTimecode;
        this.transitions = builder.transitions;
    }

    public final VideoOverlayCrop crop() {
        return this.crop;
    }

    public final String endTimecode() {
        return this.endTimecode;
    }

    public final VideoOverlayPosition initialPosition() {
        return this.initialPosition;
    }

    public final VideoOverlayInput input() {
        return this.input;
    }

    public final VideoOverlayPlayBackMode playback() {
        return VideoOverlayPlayBackMode.fromValue(this.playback);
    }

    public final String playbackAsString() {
        return this.playback;
    }

    public final String startTimecode() {
        return this.startTimecode;
    }

    public final boolean hasTransitions() {
        return this.transitions != null && !(this.transitions instanceof SdkAutoConstructList);
    }

    public final List<VideoOverlayTransition> transitions() {
        return this.transitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crop());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimecode());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimecode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitions() ? this.transitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoOverlay)) {
            return false;
        }
        VideoOverlay other = (VideoOverlay)obj;
        return Objects.equals(this.crop(), other.crop()) && Objects.equals(this.endTimecode(), other.endTimecode()) && Objects.equals(this.initialPosition(), other.initialPosition()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.playbackAsString(), other.playbackAsString()) && Objects.equals(this.startTimecode(), other.startTimecode()) && this.hasTransitions() == other.hasTransitions() && Objects.equals(this.transitions(), other.transitions());
    }

    public final String toString() {
        return ToString.builder((String)"VideoOverlay").add("Crop", (Object)this.crop()).add("EndTimecode", (Object)this.endTimecode()).add("InitialPosition", (Object)this.initialPosition()).add("Input", (Object)this.input()).add("Playback", (Object)this.playbackAsString()).add("StartTimecode", (Object)this.startTimecode()).add("Transitions", this.hasTransitions() ? this.transitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Crop": {
                return Optional.ofNullable(clazz.cast(this.crop()));
            }
            case "EndTimecode": {
                return Optional.ofNullable(clazz.cast(this.endTimecode()));
            }
            case "InitialPosition": {
                return Optional.ofNullable(clazz.cast(this.initialPosition()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "Playback": {
                return Optional.ofNullable(clazz.cast(this.playbackAsString()));
            }
            case "StartTimecode": {
                return Optional.ofNullable(clazz.cast(this.startTimecode()));
            }
            case "Transitions": {
                return Optional.ofNullable(clazz.cast(this.transitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("crop", CROP_FIELD);
        map.put("endTimecode", END_TIMECODE_FIELD);
        map.put("initialPosition", INITIAL_POSITION_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("playback", PLAYBACK_FIELD);
        map.put("startTimecode", START_TIMECODE_FIELD);
        map.put("transitions", TRANSITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoOverlay, T> g) {
        return obj -> g.apply((VideoOverlay)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VideoOverlayCrop crop;
        private String endTimecode;
        private VideoOverlayPosition initialPosition;
        private VideoOverlayInput input;
        private String playback;
        private String startTimecode;
        private List<VideoOverlayTransition> transitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VideoOverlay model) {
            this.crop(model.crop);
            this.endTimecode(model.endTimecode);
            this.initialPosition(model.initialPosition);
            this.input(model.input);
            this.playback(model.playback);
            this.startTimecode(model.startTimecode);
            this.transitions(model.transitions);
        }

        public final VideoOverlayCrop.Builder getCrop() {
            return this.crop != null ? this.crop.toBuilder() : null;
        }

        public final void setCrop(VideoOverlayCrop.BuilderImpl crop) {
            this.crop = crop != null ? crop.build() : null;
        }

        @Override
        public final Builder crop(VideoOverlayCrop crop) {
            this.crop = crop;
            return this;
        }

        public final String getEndTimecode() {
            return this.endTimecode;
        }

        public final void setEndTimecode(String endTimecode) {
            this.endTimecode = endTimecode;
        }

        @Override
        public final Builder endTimecode(String endTimecode) {
            this.endTimecode = endTimecode;
            return this;
        }

        public final VideoOverlayPosition.Builder getInitialPosition() {
            return this.initialPosition != null ? this.initialPosition.toBuilder() : null;
        }

        public final void setInitialPosition(VideoOverlayPosition.BuilderImpl initialPosition) {
            this.initialPosition = initialPosition != null ? initialPosition.build() : null;
        }

        @Override
        public final Builder initialPosition(VideoOverlayPosition initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        public final VideoOverlayInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(VideoOverlayInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(VideoOverlayInput input) {
            this.input = input;
            return this;
        }

        public final String getPlayback() {
            return this.playback;
        }

        public final void setPlayback(String playback) {
            this.playback = playback;
        }

        @Override
        public final Builder playback(String playback) {
            this.playback = playback;
            return this;
        }

        @Override
        public final Builder playback(VideoOverlayPlayBackMode playback) {
            this.playback(playback == null ? null : playback.toString());
            return this;
        }

        public final String getStartTimecode() {
            return this.startTimecode;
        }

        public final void setStartTimecode(String startTimecode) {
            this.startTimecode = startTimecode;
        }

        @Override
        public final Builder startTimecode(String startTimecode) {
            this.startTimecode = startTimecode;
            return this;
        }

        public final List<VideoOverlayTransition.Builder> getTransitions() {
            List<VideoOverlayTransition.Builder> result = ___listOfVideoOverlayTransitionCopier.copyToBuilder(this.transitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitions(Collection<VideoOverlayTransition.BuilderImpl> transitions) {
            this.transitions = ___listOfVideoOverlayTransitionCopier.copyFromBuilder(transitions);
        }

        @Override
        public final Builder transitions(Collection<VideoOverlayTransition> transitions) {
            this.transitions = ___listOfVideoOverlayTransitionCopier.copy(transitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(VideoOverlayTransition ... transitions) {
            this.transitions(Arrays.asList(transitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(Consumer<VideoOverlayTransition.Builder> ... transitions) {
            this.transitions(Stream.of(transitions).map(c -> (VideoOverlayTransition)((VideoOverlayTransition.Builder)VideoOverlayTransition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VideoOverlay build() {
            return new VideoOverlay(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoOverlay> {
        public Builder crop(VideoOverlayCrop var1);

        default public Builder crop(Consumer<VideoOverlayCrop.Builder> crop) {
            return this.crop((VideoOverlayCrop)((VideoOverlayCrop.Builder)VideoOverlayCrop.builder().applyMutation(crop)).build());
        }

        public Builder endTimecode(String var1);

        public Builder initialPosition(VideoOverlayPosition var1);

        default public Builder initialPosition(Consumer<VideoOverlayPosition.Builder> initialPosition) {
            return this.initialPosition((VideoOverlayPosition)((VideoOverlayPosition.Builder)VideoOverlayPosition.builder().applyMutation(initialPosition)).build());
        }

        public Builder input(VideoOverlayInput var1);

        default public Builder input(Consumer<VideoOverlayInput.Builder> input) {
            return this.input((VideoOverlayInput)((VideoOverlayInput.Builder)VideoOverlayInput.builder().applyMutation(input)).build());
        }

        public Builder playback(String var1);

        public Builder playback(VideoOverlayPlayBackMode var1);

        public Builder startTimecode(String var1);

        public Builder transitions(Collection<VideoOverlayTransition> var1);

        public Builder transitions(VideoOverlayTransition ... var1);

        public Builder transitions(Consumer<VideoOverlayTransition.Builder> ... var1);
    }
}

