/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducerFilter;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducerFilterSettings;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducerSpatialFilterSettings;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducerTemporalFilterSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NoiseReducer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NoiseReducer> {
    private static final SdkField<String> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Filter").getter(NoiseReducer.getter(NoiseReducer::filterAsString)).setter(NoiseReducer.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<NoiseReducerFilterSettings> FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterSettings").getter(NoiseReducer.getter(NoiseReducer::filterSettings)).setter(NoiseReducer.setter(Builder::filterSettings)).constructor(NoiseReducerFilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterSettings").build()}).build();
    private static final SdkField<NoiseReducerSpatialFilterSettings> SPATIAL_FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpatialFilterSettings").getter(NoiseReducer.getter(NoiseReducer::spatialFilterSettings)).setter(NoiseReducer.setter(Builder::spatialFilterSettings)).constructor(NoiseReducerSpatialFilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialFilterSettings").build()}).build();
    private static final SdkField<NoiseReducerTemporalFilterSettings> TEMPORAL_FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemporalFilterSettings").getter(NoiseReducer.getter(NoiseReducer::temporalFilterSettings)).setter(NoiseReducer.setter(Builder::temporalFilterSettings)).constructor(NoiseReducerTemporalFilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalFilterSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, FILTER_SETTINGS_FIELD, SPATIAL_FILTER_SETTINGS_FIELD, TEMPORAL_FILTER_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NoiseReducer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filter;
    private final NoiseReducerFilterSettings filterSettings;
    private final NoiseReducerSpatialFilterSettings spatialFilterSettings;
    private final NoiseReducerTemporalFilterSettings temporalFilterSettings;

    private NoiseReducer(BuilderImpl builder) {
        this.filter = builder.filter;
        this.filterSettings = builder.filterSettings;
        this.spatialFilterSettings = builder.spatialFilterSettings;
        this.temporalFilterSettings = builder.temporalFilterSettings;
    }

    public final NoiseReducerFilter filter() {
        return NoiseReducerFilter.fromValue(this.filter);
    }

    public final String filterAsString() {
        return this.filter;
    }

    public final NoiseReducerFilterSettings filterSettings() {
        return this.filterSettings;
    }

    public final NoiseReducerSpatialFilterSettings spatialFilterSettings() {
        return this.spatialFilterSettings;
    }

    public final NoiseReducerTemporalFilterSettings temporalFilterSettings() {
        return this.temporalFilterSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialFilterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalFilterSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoiseReducer)) {
            return false;
        }
        NoiseReducer other = (NoiseReducer)obj;
        return Objects.equals(this.filterAsString(), other.filterAsString()) && Objects.equals(this.filterSettings(), other.filterSettings()) && Objects.equals(this.spatialFilterSettings(), other.spatialFilterSettings()) && Objects.equals(this.temporalFilterSettings(), other.temporalFilterSettings());
    }

    public final String toString() {
        return ToString.builder((String)"NoiseReducer").add("Filter", (Object)this.filterAsString()).add("FilterSettings", (Object)this.filterSettings()).add("SpatialFilterSettings", (Object)this.spatialFilterSettings()).add("TemporalFilterSettings", (Object)this.temporalFilterSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filterAsString()));
            }
            case "FilterSettings": {
                return Optional.ofNullable(clazz.cast(this.filterSettings()));
            }
            case "SpatialFilterSettings": {
                return Optional.ofNullable(clazz.cast(this.spatialFilterSettings()));
            }
            case "TemporalFilterSettings": {
                return Optional.ofNullable(clazz.cast(this.temporalFilterSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filter", FILTER_FIELD);
        map.put("filterSettings", FILTER_SETTINGS_FIELD);
        map.put("spatialFilterSettings", SPATIAL_FILTER_SETTINGS_FIELD);
        map.put("temporalFilterSettings", TEMPORAL_FILTER_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NoiseReducer, T> g) {
        return obj -> g.apply((NoiseReducer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filter;
        private NoiseReducerFilterSettings filterSettings;
        private NoiseReducerSpatialFilterSettings spatialFilterSettings;
        private NoiseReducerTemporalFilterSettings temporalFilterSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(NoiseReducer model) {
            this.filter(model.filter);
            this.filterSettings(model.filterSettings);
            this.spatialFilterSettings(model.spatialFilterSettings);
            this.temporalFilterSettings(model.temporalFilterSettings);
        }

        public final String getFilter() {
            return this.filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public final Builder filter(NoiseReducerFilter filter) {
            this.filter(filter == null ? null : filter.toString());
            return this;
        }

        public final NoiseReducerFilterSettings.Builder getFilterSettings() {
            return this.filterSettings != null ? this.filterSettings.toBuilder() : null;
        }

        public final void setFilterSettings(NoiseReducerFilterSettings.BuilderImpl filterSettings) {
            this.filterSettings = filterSettings != null ? filterSettings.build() : null;
        }

        @Override
        public final Builder filterSettings(NoiseReducerFilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public final NoiseReducerSpatialFilterSettings.Builder getSpatialFilterSettings() {
            return this.spatialFilterSettings != null ? this.spatialFilterSettings.toBuilder() : null;
        }

        public final void setSpatialFilterSettings(NoiseReducerSpatialFilterSettings.BuilderImpl spatialFilterSettings) {
            this.spatialFilterSettings = spatialFilterSettings != null ? spatialFilterSettings.build() : null;
        }

        @Override
        public final Builder spatialFilterSettings(NoiseReducerSpatialFilterSettings spatialFilterSettings) {
            this.spatialFilterSettings = spatialFilterSettings;
            return this;
        }

        public final NoiseReducerTemporalFilterSettings.Builder getTemporalFilterSettings() {
            return this.temporalFilterSettings != null ? this.temporalFilterSettings.toBuilder() : null;
        }

        public final void setTemporalFilterSettings(NoiseReducerTemporalFilterSettings.BuilderImpl temporalFilterSettings) {
            this.temporalFilterSettings = temporalFilterSettings != null ? temporalFilterSettings.build() : null;
        }

        @Override
        public final Builder temporalFilterSettings(NoiseReducerTemporalFilterSettings temporalFilterSettings) {
            this.temporalFilterSettings = temporalFilterSettings;
            return this;
        }

        public NoiseReducer build() {
            return new NoiseReducer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NoiseReducer> {
        public Builder filter(String var1);

        public Builder filter(NoiseReducerFilter var1);

        public Builder filterSettings(NoiseReducerFilterSettings var1);

        default public Builder filterSettings(Consumer<NoiseReducerFilterSettings.Builder> filterSettings) {
            return this.filterSettings((NoiseReducerFilterSettings)((NoiseReducerFilterSettings.Builder)NoiseReducerFilterSettings.builder().applyMutation(filterSettings)).build());
        }

        public Builder spatialFilterSettings(NoiseReducerSpatialFilterSettings var1);

        default public Builder spatialFilterSettings(Consumer<NoiseReducerSpatialFilterSettings.Builder> spatialFilterSettings) {
            return this.spatialFilterSettings((NoiseReducerSpatialFilterSettings)((NoiseReducerSpatialFilterSettings.Builder)NoiseReducerSpatialFilterSettings.builder().applyMutation(spatialFilterSettings)).build());
        }

        public Builder temporalFilterSettings(NoiseReducerTemporalFilterSettings var1);

        default public Builder temporalFilterSettings(Consumer<NoiseReducerTemporalFilterSettings.Builder> temporalFilterSettings) {
            return this.temporalFilterSettings((NoiseReducerTemporalFilterSettings)((NoiseReducerTemporalFilterSettings.Builder)NoiseReducerTemporalFilterSettings.builder().applyMutation(temporalFilterSettings)).build());
        }
    }
}

