/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AudioProperties;
import software.amazon.awssdk.services.mediaconvert.model.Codec;
import software.amazon.awssdk.services.mediaconvert.model.DataProperties;
import software.amazon.awssdk.services.mediaconvert.model.TrackType;
import software.amazon.awssdk.services.mediaconvert.model.VideoProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Track
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Track> {
    private static final SdkField<AudioProperties> AUDIO_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioProperties").getter(Track.getter(Track::audioProperties)).setter(Track.setter(Builder::audioProperties)).constructor(AudioProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioProperties").build()}).build();
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Codec").getter(Track.getter(Track::codecAsString)).setter(Track.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()}).build();
    private static final SdkField<DataProperties> DATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataProperties").getter(Track.getter(Track::dataProperties)).setter(Track.setter(Builder::dataProperties)).constructor(DataProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProperties").build()}).build();
    private static final SdkField<Double> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Duration").getter(Track.getter(Track::duration)).setter(Track.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Index").getter(Track.getter(Track::index)).setter(Track.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()}).build();
    private static final SdkField<String> TRACK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackType").getter(Track.getter(Track::trackTypeAsString)).setter(Track.setter(Builder::trackType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackType").build()}).build();
    private static final SdkField<VideoProperties> VIDEO_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoProperties").getter(Track.getter(Track::videoProperties)).setter(Track.setter(Builder::videoProperties)).constructor(VideoProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_PROPERTIES_FIELD, CODEC_FIELD, DATA_PROPERTIES_FIELD, DURATION_FIELD, INDEX_FIELD, TRACK_TYPE_FIELD, VIDEO_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Track.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AudioProperties audioProperties;
    private final String codec;
    private final DataProperties dataProperties;
    private final Double duration;
    private final Integer index;
    private final String trackType;
    private final VideoProperties videoProperties;

    private Track(BuilderImpl builder) {
        this.audioProperties = builder.audioProperties;
        this.codec = builder.codec;
        this.dataProperties = builder.dataProperties;
        this.duration = builder.duration;
        this.index = builder.index;
        this.trackType = builder.trackType;
        this.videoProperties = builder.videoProperties;
    }

    public final AudioProperties audioProperties() {
        return this.audioProperties;
    }

    public final Codec codec() {
        return Codec.fromValue(this.codec);
    }

    public final String codecAsString() {
        return this.codec;
    }

    public final DataProperties dataProperties() {
        return this.dataProperties;
    }

    public final Double duration() {
        return this.duration;
    }

    public final Integer index() {
        return this.index;
    }

    public final TrackType trackType() {
        return TrackType.fromValue(this.trackType);
    }

    public final String trackTypeAsString() {
        return this.trackType;
    }

    public final VideoProperties videoProperties() {
        return this.videoProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Track)) {
            return false;
        }
        Track other = (Track)obj;
        return Objects.equals(this.audioProperties(), other.audioProperties()) && Objects.equals(this.codecAsString(), other.codecAsString()) && Objects.equals(this.dataProperties(), other.dataProperties()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.index(), other.index()) && Objects.equals(this.trackTypeAsString(), other.trackTypeAsString()) && Objects.equals(this.videoProperties(), other.videoProperties());
    }

    public final String toString() {
        return ToString.builder((String)"Track").add("AudioProperties", (Object)this.audioProperties()).add("Codec", (Object)this.codecAsString()).add("DataProperties", (Object)this.dataProperties()).add("Duration", (Object)this.duration()).add("Index", (Object)this.index()).add("TrackType", (Object)this.trackTypeAsString()).add("VideoProperties", (Object)this.videoProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioProperties": {
                return Optional.ofNullable(clazz.cast(this.audioProperties()));
            }
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codecAsString()));
            }
            case "DataProperties": {
                return Optional.ofNullable(clazz.cast(this.dataProperties()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "TrackType": {
                return Optional.ofNullable(clazz.cast(this.trackTypeAsString()));
            }
            case "VideoProperties": {
                return Optional.ofNullable(clazz.cast(this.videoProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("audioProperties", AUDIO_PROPERTIES_FIELD);
        map.put("codec", CODEC_FIELD);
        map.put("dataProperties", DATA_PROPERTIES_FIELD);
        map.put("duration", DURATION_FIELD);
        map.put("index", INDEX_FIELD);
        map.put("trackType", TRACK_TYPE_FIELD);
        map.put("videoProperties", VIDEO_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Track, T> g) {
        return obj -> g.apply((Track)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioProperties audioProperties;
        private String codec;
        private DataProperties dataProperties;
        private Double duration;
        private Integer index;
        private String trackType;
        private VideoProperties videoProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(Track model) {
            this.audioProperties(model.audioProperties);
            this.codec(model.codec);
            this.dataProperties(model.dataProperties);
            this.duration(model.duration);
            this.index(model.index);
            this.trackType(model.trackType);
            this.videoProperties(model.videoProperties);
        }

        public final AudioProperties.Builder getAudioProperties() {
            return this.audioProperties != null ? this.audioProperties.toBuilder() : null;
        }

        public final void setAudioProperties(AudioProperties.BuilderImpl audioProperties) {
            this.audioProperties = audioProperties != null ? audioProperties.build() : null;
        }

        @Override
        public final Builder audioProperties(AudioProperties audioProperties) {
            this.audioProperties = audioProperties;
            return this;
        }

        public final String getCodec() {
            return this.codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(Codec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final DataProperties.Builder getDataProperties() {
            return this.dataProperties != null ? this.dataProperties.toBuilder() : null;
        }

        public final void setDataProperties(DataProperties.BuilderImpl dataProperties) {
            this.dataProperties = dataProperties != null ? dataProperties.build() : null;
        }

        @Override
        public final Builder dataProperties(DataProperties dataProperties) {
            this.dataProperties = dataProperties;
            return this;
        }

        public final Double getDuration() {
            return this.duration;
        }

        public final void setDuration(Double duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Double duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getIndex() {
            return this.index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final String getTrackType() {
            return this.trackType;
        }

        public final void setTrackType(String trackType) {
            this.trackType = trackType;
        }

        @Override
        public final Builder trackType(String trackType) {
            this.trackType = trackType;
            return this;
        }

        @Override
        public final Builder trackType(TrackType trackType) {
            this.trackType(trackType == null ? null : trackType.toString());
            return this;
        }

        public final VideoProperties.Builder getVideoProperties() {
            return this.videoProperties != null ? this.videoProperties.toBuilder() : null;
        }

        public final void setVideoProperties(VideoProperties.BuilderImpl videoProperties) {
            this.videoProperties = videoProperties != null ? videoProperties.build() : null;
        }

        @Override
        public final Builder videoProperties(VideoProperties videoProperties) {
            this.videoProperties = videoProperties;
            return this;
        }

        public Track build() {
            return new Track(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Track> {
        public Builder audioProperties(AudioProperties var1);

        default public Builder audioProperties(Consumer<AudioProperties.Builder> audioProperties) {
            return this.audioProperties((AudioProperties)((AudioProperties.Builder)AudioProperties.builder().applyMutation(audioProperties)).build());
        }

        public Builder codec(String var1);

        public Builder codec(Codec var1);

        public Builder dataProperties(DataProperties var1);

        default public Builder dataProperties(Consumer<DataProperties.Builder> dataProperties) {
            return this.dataProperties((DataProperties)((DataProperties.Builder)DataProperties.builder().applyMutation(dataProperties)).build());
        }

        public Builder duration(Double var1);

        public Builder index(Integer var1);

        public Builder trackType(String var1);

        public Builder trackType(TrackType var1);

        public Builder videoProperties(VideoProperties var1);

        default public Builder videoProperties(Consumer<VideoProperties.Builder> videoProperties) {
            return this.videoProperties((VideoProperties)((VideoProperties.Builder)VideoProperties.builder().applyMutation(videoProperties)).build());
        }
    }
}

