/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Vp8FramerateConversionAlgorithm {
    DUPLICATE_DROP("DUPLICATE_DROP"),
    INTERPOLATE("INTERPOLATE"),
    FRAMEFORMER("FRAMEFORMER"),
    MAINTAIN_FRAME_COUNT("MAINTAIN_FRAME_COUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Vp8FramerateConversionAlgorithm> VALUE_MAP;
    private final String value;

    private Vp8FramerateConversionAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Vp8FramerateConversionAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Vp8FramerateConversionAlgorithm> knownValues() {
        EnumSet<Vp8FramerateConversionAlgorithm> knownValues = EnumSet.allOf(Vp8FramerateConversionAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Vp8FramerateConversionAlgorithm.class, Vp8FramerateConversionAlgorithm::toString);
    }
}

