/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.FrameMetricType;
import software.amazon.awssdk.services.mediaconvert.model.ProresChromaSampling;
import software.amazon.awssdk.services.mediaconvert.model.ProresCodecProfile;
import software.amazon.awssdk.services.mediaconvert.model.ProresFramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.ProresFramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.ProresInterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.ProresParControl;
import software.amazon.awssdk.services.mediaconvert.model.ProresScanTypeConversionMode;
import software.amazon.awssdk.services.mediaconvert.model.ProresSlowPal;
import software.amazon.awssdk.services.mediaconvert.model.ProresTelecine;
import software.amazon.awssdk.services.mediaconvert.model.___listOfFrameMetricTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProresSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProresSettings> {
    private static final SdkField<String> CHROMA_SAMPLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChromaSampling").getter(ProresSettings.getter(ProresSettings::chromaSamplingAsString)).setter(ProresSettings.setter(Builder::chromaSampling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chromaSampling").build()}).build();
    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodecProfile").getter(ProresSettings.getter(ProresSettings::codecProfileAsString)).setter(ProresSettings.setter(Builder::codecProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()}).build();
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateControl").getter(ProresSettings.getter(ProresSettings::framerateControlAsString)).setter(ProresSettings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateConversionAlgorithm").getter(ProresSettings.getter(ProresSettings::framerateConversionAlgorithmAsString)).setter(ProresSettings.setter(Builder::framerateConversionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(ProresSettings.getter(ProresSettings::framerateDenominator)).setter(ProresSettings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(ProresSettings.getter(ProresSettings::framerateNumerator)).setter(ProresSettings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterlaceMode").getter(ProresSettings.getter(ProresSettings::interlaceModeAsString)).setter(ProresSettings.setter(Builder::interlaceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()}).build();
    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParControl").getter(ProresSettings.getter(ProresSettings::parControlAsString)).setter(ProresSettings.setter(Builder::parControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()}).build();
    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParDenominator").getter(ProresSettings.getter(ProresSettings::parDenominator)).setter(ProresSettings.setter(Builder::parDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()}).build();
    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParNumerator").getter(ProresSettings.getter(ProresSettings::parNumerator)).setter(ProresSettings.setter(Builder::parNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()}).build();
    private static final SdkField<List<String>> PER_FRAME_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PerFrameMetrics").getter(ProresSettings.getter(ProresSettings::perFrameMetricsAsStrings)).setter(ProresSettings.setter(Builder::perFrameMetricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("perFrameMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCAN_TYPE_CONVERSION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanTypeConversionMode").getter(ProresSettings.getter(ProresSettings::scanTypeConversionModeAsString)).setter(ProresSettings.setter(Builder::scanTypeConversionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanTypeConversionMode").build()}).build();
    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlowPal").getter(ProresSettings.getter(ProresSettings::slowPalAsString)).setter(ProresSettings.setter(Builder::slowPal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()}).build();
    private static final SdkField<String> TELECINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Telecine").getter(ProresSettings.getter(ProresSettings::telecineAsString)).setter(ProresSettings.setter(Builder::telecine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHROMA_SAMPLING_FIELD, CODEC_PROFILE_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, INTERLACE_MODE_FIELD, PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, PER_FRAME_METRICS_FIELD, SCAN_TYPE_CONVERSION_MODE_FIELD, SLOW_PAL_FIELD, TELECINE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProresSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String chromaSampling;
    private final String codecProfile;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String interlaceMode;
    private final String parControl;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final List<String> perFrameMetrics;
    private final String scanTypeConversionMode;
    private final String slowPal;
    private final String telecine;

    private ProresSettings(BuilderImpl builder) {
        this.chromaSampling = builder.chromaSampling;
        this.codecProfile = builder.codecProfile;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.interlaceMode = builder.interlaceMode;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.perFrameMetrics = builder.perFrameMetrics;
        this.scanTypeConversionMode = builder.scanTypeConversionMode;
        this.slowPal = builder.slowPal;
        this.telecine = builder.telecine;
    }

    public final ProresChromaSampling chromaSampling() {
        return ProresChromaSampling.fromValue(this.chromaSampling);
    }

    public final String chromaSamplingAsString() {
        return this.chromaSampling;
    }

    public final ProresCodecProfile codecProfile() {
        return ProresCodecProfile.fromValue(this.codecProfile);
    }

    public final String codecProfileAsString() {
        return this.codecProfile;
    }

    public final ProresFramerateControl framerateControl() {
        return ProresFramerateControl.fromValue(this.framerateControl);
    }

    public final String framerateControlAsString() {
        return this.framerateControl;
    }

    public final ProresFramerateConversionAlgorithm framerateConversionAlgorithm() {
        return ProresFramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public final String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final ProresInterlaceMode interlaceMode() {
        return ProresInterlaceMode.fromValue(this.interlaceMode);
    }

    public final String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public final ProresParControl parControl() {
        return ProresParControl.fromValue(this.parControl);
    }

    public final String parControlAsString() {
        return this.parControl;
    }

    public final Integer parDenominator() {
        return this.parDenominator;
    }

    public final Integer parNumerator() {
        return this.parNumerator;
    }

    public final List<FrameMetricType> perFrameMetrics() {
        return ___listOfFrameMetricTypeCopier.copyStringToEnum(this.perFrameMetrics);
    }

    public final boolean hasPerFrameMetrics() {
        return this.perFrameMetrics != null && !(this.perFrameMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> perFrameMetricsAsStrings() {
        return this.perFrameMetrics;
    }

    public final ProresScanTypeConversionMode scanTypeConversionMode() {
        return ProresScanTypeConversionMode.fromValue(this.scanTypeConversionMode);
    }

    public final String scanTypeConversionModeAsString() {
        return this.scanTypeConversionMode;
    }

    public final ProresSlowPal slowPal() {
        return ProresSlowPal.fromValue(this.slowPal);
    }

    public final String slowPalAsString() {
        return this.slowPal;
    }

    public final ProresTelecine telecine() {
        return ProresTelecine.fromValue(this.telecine);
    }

    public final String telecineAsString() {
        return this.telecine;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.chromaSamplingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPerFrameMetrics() ? this.perFrameMetricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeConversionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProresSettings)) {
            return false;
        }
        ProresSettings other = (ProresSettings)obj;
        return Objects.equals(this.chromaSamplingAsString(), other.chromaSamplingAsString()) && Objects.equals(this.codecProfileAsString(), other.codecProfileAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.parControlAsString(), other.parControlAsString()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && this.hasPerFrameMetrics() == other.hasPerFrameMetrics() && Objects.equals(this.perFrameMetricsAsStrings(), other.perFrameMetricsAsStrings()) && Objects.equals(this.scanTypeConversionModeAsString(), other.scanTypeConversionModeAsString()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.telecineAsString(), other.telecineAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProresSettings").add("ChromaSampling", (Object)this.chromaSamplingAsString()).add("CodecProfile", (Object)this.codecProfileAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("ParControl", (Object)this.parControlAsString()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("PerFrameMetrics", this.hasPerFrameMetrics() ? this.perFrameMetricsAsStrings() : null).add("ScanTypeConversionMode", (Object)this.scanTypeConversionModeAsString()).add("SlowPal", (Object)this.slowPalAsString()).add("Telecine", (Object)this.telecineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChromaSampling": {
                return Optional.ofNullable(clazz.cast(this.chromaSamplingAsString()));
            }
            case "CodecProfile": {
                return Optional.ofNullable(clazz.cast(this.codecProfileAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "InterlaceMode": {
                return Optional.ofNullable(clazz.cast(this.interlaceModeAsString()));
            }
            case "ParControl": {
                return Optional.ofNullable(clazz.cast(this.parControlAsString()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "PerFrameMetrics": {
                return Optional.ofNullable(clazz.cast(this.perFrameMetricsAsStrings()));
            }
            case "ScanTypeConversionMode": {
                return Optional.ofNullable(clazz.cast(this.scanTypeConversionModeAsString()));
            }
            case "SlowPal": {
                return Optional.ofNullable(clazz.cast(this.slowPalAsString()));
            }
            case "Telecine": {
                return Optional.ofNullable(clazz.cast(this.telecineAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("chromaSampling", CHROMA_SAMPLING_FIELD);
        map.put("codecProfile", CODEC_PROFILE_FIELD);
        map.put("framerateControl", FRAMERATE_CONTROL_FIELD);
        map.put("framerateConversionAlgorithm", FRAMERATE_CONVERSION_ALGORITHM_FIELD);
        map.put("framerateDenominator", FRAMERATE_DENOMINATOR_FIELD);
        map.put("framerateNumerator", FRAMERATE_NUMERATOR_FIELD);
        map.put("interlaceMode", INTERLACE_MODE_FIELD);
        map.put("parControl", PAR_CONTROL_FIELD);
        map.put("parDenominator", PAR_DENOMINATOR_FIELD);
        map.put("parNumerator", PAR_NUMERATOR_FIELD);
        map.put("perFrameMetrics", PER_FRAME_METRICS_FIELD);
        map.put("scanTypeConversionMode", SCAN_TYPE_CONVERSION_MODE_FIELD);
        map.put("slowPal", SLOW_PAL_FIELD);
        map.put("telecine", TELECINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProresSettings, T> g) {
        return obj -> g.apply((ProresSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String chromaSampling;
        private String codecProfile;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String interlaceMode;
        private String parControl;
        private Integer parDenominator;
        private Integer parNumerator;
        private List<String> perFrameMetrics = DefaultSdkAutoConstructList.getInstance();
        private String scanTypeConversionMode;
        private String slowPal;
        private String telecine;

        private BuilderImpl() {
        }

        private BuilderImpl(ProresSettings model) {
            this.chromaSampling(model.chromaSampling);
            this.codecProfile(model.codecProfile);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.interlaceMode(model.interlaceMode);
            this.parControl(model.parControl);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.perFrameMetricsWithStrings(model.perFrameMetrics);
            this.scanTypeConversionMode(model.scanTypeConversionMode);
            this.slowPal(model.slowPal);
            this.telecine(model.telecine);
        }

        public final String getChromaSampling() {
            return this.chromaSampling;
        }

        public final void setChromaSampling(String chromaSampling) {
            this.chromaSampling = chromaSampling;
        }

        @Override
        public final Builder chromaSampling(String chromaSampling) {
            this.chromaSampling = chromaSampling;
            return this;
        }

        @Override
        public final Builder chromaSampling(ProresChromaSampling chromaSampling) {
            this.chromaSampling(chromaSampling == null ? null : chromaSampling.toString());
            return this;
        }

        public final String getCodecProfile() {
            return this.codecProfile;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(ProresCodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(ProresFramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(ProresFramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(ProresInterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final String getParControl() {
            return this.parControl;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(ProresParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final Collection<String> getPerFrameMetrics() {
            if (this.perFrameMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.perFrameMetrics;
        }

        public final void setPerFrameMetrics(Collection<String> perFrameMetrics) {
            this.perFrameMetrics = ___listOfFrameMetricTypeCopier.copy(perFrameMetrics);
        }

        @Override
        public final Builder perFrameMetricsWithStrings(Collection<String> perFrameMetrics) {
            this.perFrameMetrics = ___listOfFrameMetricTypeCopier.copy(perFrameMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder perFrameMetricsWithStrings(String ... perFrameMetrics) {
            this.perFrameMetricsWithStrings(Arrays.asList(perFrameMetrics));
            return this;
        }

        @Override
        public final Builder perFrameMetrics(Collection<FrameMetricType> perFrameMetrics) {
            this.perFrameMetrics = ___listOfFrameMetricTypeCopier.copyEnumToString(perFrameMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder perFrameMetrics(FrameMetricType ... perFrameMetrics) {
            this.perFrameMetrics(Arrays.asList(perFrameMetrics));
            return this;
        }

        public final String getScanTypeConversionMode() {
            return this.scanTypeConversionMode;
        }

        public final void setScanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
        }

        @Override
        public final Builder scanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
            return this;
        }

        @Override
        public final Builder scanTypeConversionMode(ProresScanTypeConversionMode scanTypeConversionMode) {
            this.scanTypeConversionMode(scanTypeConversionMode == null ? null : scanTypeConversionMode.toString());
            return this;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(ProresSlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(ProresTelecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public ProresSettings build() {
            return new ProresSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProresSettings> {
        public Builder chromaSampling(String var1);

        public Builder chromaSampling(ProresChromaSampling var1);

        public Builder codecProfile(String var1);

        public Builder codecProfile(ProresCodecProfile var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(ProresFramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(ProresFramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(ProresInterlaceMode var1);

        public Builder parControl(String var1);

        public Builder parControl(ProresParControl var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder perFrameMetricsWithStrings(Collection<String> var1);

        public Builder perFrameMetricsWithStrings(String ... var1);

        public Builder perFrameMetrics(Collection<FrameMetricType> var1);

        public Builder perFrameMetrics(FrameMetricType ... var1);

        public Builder scanTypeConversionMode(String var1);

        public Builder scanTypeConversionMode(ProresScanTypeConversionMode var1);

        public Builder slowPal(String var1);

        public Builder slowPal(ProresSlowPal var1);

        public Builder telecine(String var1);

        public Builder telecine(ProresTelecine var1);
    }
}

