/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AncillarySourceSettings;
import software.amazon.awssdk.services.mediaconvert.model.CaptionSourceType;
import software.amazon.awssdk.services.mediaconvert.model.DvbSubSourceSettings;
import software.amazon.awssdk.services.mediaconvert.model.EmbeddedSourceSettings;
import software.amazon.awssdk.services.mediaconvert.model.FileSourceSettings;
import software.amazon.awssdk.services.mediaconvert.model.TeletextSourceSettings;
import software.amazon.awssdk.services.mediaconvert.model.TrackSourceSettings;
import software.amazon.awssdk.services.mediaconvert.model.WebvttHlsSourceSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaptionSourceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaptionSourceSettings> {
    private static final SdkField<AncillarySourceSettings> ANCILLARY_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AncillarySourceSettings").getter(CaptionSourceSettings.getter(CaptionSourceSettings::ancillarySourceSettings)).setter(CaptionSourceSettings.setter(Builder::ancillarySourceSettings)).constructor(AncillarySourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ancillarySourceSettings").build()}).build();
    private static final SdkField<DvbSubSourceSettings> DVB_SUB_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DvbSubSourceSettings").getter(CaptionSourceSettings.getter(CaptionSourceSettings::dvbSubSourceSettings)).setter(CaptionSourceSettings.setter(Builder::dvbSubSourceSettings)).constructor(DvbSubSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSubSourceSettings").build()}).build();
    private static final SdkField<EmbeddedSourceSettings> EMBEDDED_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmbeddedSourceSettings").getter(CaptionSourceSettings.getter(CaptionSourceSettings::embeddedSourceSettings)).setter(CaptionSourceSettings.setter(Builder::embeddedSourceSettings)).constructor(EmbeddedSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddedSourceSettings").build()}).build();
    private static final SdkField<FileSourceSettings> FILE_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FileSourceSettings").getter(CaptionSourceSettings.getter(CaptionSourceSettings::fileSourceSettings)).setter(CaptionSourceSettings.setter(Builder::fileSourceSettings)).constructor(FileSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSourceSettings").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(CaptionSourceSettings.getter(CaptionSourceSettings::sourceTypeAsString)).setter(CaptionSourceSettings.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final SdkField<TeletextSourceSettings> TELETEXT_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TeletextSourceSettings").getter(CaptionSourceSettings.getter(CaptionSourceSettings::teletextSourceSettings)).setter(CaptionSourceSettings.setter(Builder::teletextSourceSettings)).constructor(TeletextSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextSourceSettings").build()}).build();
    private static final SdkField<TrackSourceSettings> TRACK_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrackSourceSettings").getter(CaptionSourceSettings.getter(CaptionSourceSettings::trackSourceSettings)).setter(CaptionSourceSettings.setter(Builder::trackSourceSettings)).constructor(TrackSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackSourceSettings").build()}).build();
    private static final SdkField<WebvttHlsSourceSettings> WEBVTT_HLS_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WebvttHlsSourceSettings").getter(CaptionSourceSettings.getter(CaptionSourceSettings::webvttHlsSourceSettings)).setter(CaptionSourceSettings.setter(Builder::webvttHlsSourceSettings)).constructor(WebvttHlsSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webvttHlsSourceSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANCILLARY_SOURCE_SETTINGS_FIELD, DVB_SUB_SOURCE_SETTINGS_FIELD, EMBEDDED_SOURCE_SETTINGS_FIELD, FILE_SOURCE_SETTINGS_FIELD, SOURCE_TYPE_FIELD, TELETEXT_SOURCE_SETTINGS_FIELD, TRACK_SOURCE_SETTINGS_FIELD, WEBVTT_HLS_SOURCE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CaptionSourceSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AncillarySourceSettings ancillarySourceSettings;
    private final DvbSubSourceSettings dvbSubSourceSettings;
    private final EmbeddedSourceSettings embeddedSourceSettings;
    private final FileSourceSettings fileSourceSettings;
    private final String sourceType;
    private final TeletextSourceSettings teletextSourceSettings;
    private final TrackSourceSettings trackSourceSettings;
    private final WebvttHlsSourceSettings webvttHlsSourceSettings;

    private CaptionSourceSettings(BuilderImpl builder) {
        this.ancillarySourceSettings = builder.ancillarySourceSettings;
        this.dvbSubSourceSettings = builder.dvbSubSourceSettings;
        this.embeddedSourceSettings = builder.embeddedSourceSettings;
        this.fileSourceSettings = builder.fileSourceSettings;
        this.sourceType = builder.sourceType;
        this.teletextSourceSettings = builder.teletextSourceSettings;
        this.trackSourceSettings = builder.trackSourceSettings;
        this.webvttHlsSourceSettings = builder.webvttHlsSourceSettings;
    }

    public final AncillarySourceSettings ancillarySourceSettings() {
        return this.ancillarySourceSettings;
    }

    public final DvbSubSourceSettings dvbSubSourceSettings() {
        return this.dvbSubSourceSettings;
    }

    public final EmbeddedSourceSettings embeddedSourceSettings() {
        return this.embeddedSourceSettings;
    }

    public final FileSourceSettings fileSourceSettings() {
        return this.fileSourceSettings;
    }

    public final CaptionSourceType sourceType() {
        return CaptionSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final TeletextSourceSettings teletextSourceSettings() {
        return this.teletextSourceSettings;
    }

    public final TrackSourceSettings trackSourceSettings() {
        return this.trackSourceSettings;
    }

    public final WebvttHlsSourceSettings webvttHlsSourceSettings() {
        return this.webvttHlsSourceSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ancillarySourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbSubSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.embeddedSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.teletextSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.webvttHlsSourceSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSourceSettings)) {
            return false;
        }
        CaptionSourceSettings other = (CaptionSourceSettings)obj;
        return Objects.equals(this.ancillarySourceSettings(), other.ancillarySourceSettings()) && Objects.equals(this.dvbSubSourceSettings(), other.dvbSubSourceSettings()) && Objects.equals(this.embeddedSourceSettings(), other.embeddedSourceSettings()) && Objects.equals(this.fileSourceSettings(), other.fileSourceSettings()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.teletextSourceSettings(), other.teletextSourceSettings()) && Objects.equals(this.trackSourceSettings(), other.trackSourceSettings()) && Objects.equals(this.webvttHlsSourceSettings(), other.webvttHlsSourceSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CaptionSourceSettings").add("AncillarySourceSettings", (Object)this.ancillarySourceSettings()).add("DvbSubSourceSettings", (Object)this.dvbSubSourceSettings()).add("EmbeddedSourceSettings", (Object)this.embeddedSourceSettings()).add("FileSourceSettings", (Object)this.fileSourceSettings()).add("SourceType", (Object)this.sourceTypeAsString()).add("TeletextSourceSettings", (Object)this.teletextSourceSettings()).add("TrackSourceSettings", (Object)this.trackSourceSettings()).add("WebvttHlsSourceSettings", (Object)this.webvttHlsSourceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AncillarySourceSettings": {
                return Optional.ofNullable(clazz.cast(this.ancillarySourceSettings()));
            }
            case "DvbSubSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.dvbSubSourceSettings()));
            }
            case "EmbeddedSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.embeddedSourceSettings()));
            }
            case "FileSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.fileSourceSettings()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "TeletextSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.teletextSourceSettings()));
            }
            case "TrackSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.trackSourceSettings()));
            }
            case "WebvttHlsSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.webvttHlsSourceSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ancillarySourceSettings", ANCILLARY_SOURCE_SETTINGS_FIELD);
        map.put("dvbSubSourceSettings", DVB_SUB_SOURCE_SETTINGS_FIELD);
        map.put("embeddedSourceSettings", EMBEDDED_SOURCE_SETTINGS_FIELD);
        map.put("fileSourceSettings", FILE_SOURCE_SETTINGS_FIELD);
        map.put("sourceType", SOURCE_TYPE_FIELD);
        map.put("teletextSourceSettings", TELETEXT_SOURCE_SETTINGS_FIELD);
        map.put("trackSourceSettings", TRACK_SOURCE_SETTINGS_FIELD);
        map.put("webvttHlsSourceSettings", WEBVTT_HLS_SOURCE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaptionSourceSettings, T> g) {
        return obj -> g.apply((CaptionSourceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AncillarySourceSettings ancillarySourceSettings;
        private DvbSubSourceSettings dvbSubSourceSettings;
        private EmbeddedSourceSettings embeddedSourceSettings;
        private FileSourceSettings fileSourceSettings;
        private String sourceType;
        private TeletextSourceSettings teletextSourceSettings;
        private TrackSourceSettings trackSourceSettings;
        private WebvttHlsSourceSettings webvttHlsSourceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSourceSettings model) {
            this.ancillarySourceSettings(model.ancillarySourceSettings);
            this.dvbSubSourceSettings(model.dvbSubSourceSettings);
            this.embeddedSourceSettings(model.embeddedSourceSettings);
            this.fileSourceSettings(model.fileSourceSettings);
            this.sourceType(model.sourceType);
            this.teletextSourceSettings(model.teletextSourceSettings);
            this.trackSourceSettings(model.trackSourceSettings);
            this.webvttHlsSourceSettings(model.webvttHlsSourceSettings);
        }

        public final AncillarySourceSettings.Builder getAncillarySourceSettings() {
            return this.ancillarySourceSettings != null ? this.ancillarySourceSettings.toBuilder() : null;
        }

        public final void setAncillarySourceSettings(AncillarySourceSettings.BuilderImpl ancillarySourceSettings) {
            this.ancillarySourceSettings = ancillarySourceSettings != null ? ancillarySourceSettings.build() : null;
        }

        @Override
        public final Builder ancillarySourceSettings(AncillarySourceSettings ancillarySourceSettings) {
            this.ancillarySourceSettings = ancillarySourceSettings;
            return this;
        }

        public final DvbSubSourceSettings.Builder getDvbSubSourceSettings() {
            return this.dvbSubSourceSettings != null ? this.dvbSubSourceSettings.toBuilder() : null;
        }

        public final void setDvbSubSourceSettings(DvbSubSourceSettings.BuilderImpl dvbSubSourceSettings) {
            this.dvbSubSourceSettings = dvbSubSourceSettings != null ? dvbSubSourceSettings.build() : null;
        }

        @Override
        public final Builder dvbSubSourceSettings(DvbSubSourceSettings dvbSubSourceSettings) {
            this.dvbSubSourceSettings = dvbSubSourceSettings;
            return this;
        }

        public final EmbeddedSourceSettings.Builder getEmbeddedSourceSettings() {
            return this.embeddedSourceSettings != null ? this.embeddedSourceSettings.toBuilder() : null;
        }

        public final void setEmbeddedSourceSettings(EmbeddedSourceSettings.BuilderImpl embeddedSourceSettings) {
            this.embeddedSourceSettings = embeddedSourceSettings != null ? embeddedSourceSettings.build() : null;
        }

        @Override
        public final Builder embeddedSourceSettings(EmbeddedSourceSettings embeddedSourceSettings) {
            this.embeddedSourceSettings = embeddedSourceSettings;
            return this;
        }

        public final FileSourceSettings.Builder getFileSourceSettings() {
            return this.fileSourceSettings != null ? this.fileSourceSettings.toBuilder() : null;
        }

        public final void setFileSourceSettings(FileSourceSettings.BuilderImpl fileSourceSettings) {
            this.fileSourceSettings = fileSourceSettings != null ? fileSourceSettings.build() : null;
        }

        @Override
        public final Builder fileSourceSettings(FileSourceSettings fileSourceSettings) {
            this.fileSourceSettings = fileSourceSettings;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(CaptionSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final TeletextSourceSettings.Builder getTeletextSourceSettings() {
            return this.teletextSourceSettings != null ? this.teletextSourceSettings.toBuilder() : null;
        }

        public final void setTeletextSourceSettings(TeletextSourceSettings.BuilderImpl teletextSourceSettings) {
            this.teletextSourceSettings = teletextSourceSettings != null ? teletextSourceSettings.build() : null;
        }

        @Override
        public final Builder teletextSourceSettings(TeletextSourceSettings teletextSourceSettings) {
            this.teletextSourceSettings = teletextSourceSettings;
            return this;
        }

        public final TrackSourceSettings.Builder getTrackSourceSettings() {
            return this.trackSourceSettings != null ? this.trackSourceSettings.toBuilder() : null;
        }

        public final void setTrackSourceSettings(TrackSourceSettings.BuilderImpl trackSourceSettings) {
            this.trackSourceSettings = trackSourceSettings != null ? trackSourceSettings.build() : null;
        }

        @Override
        public final Builder trackSourceSettings(TrackSourceSettings trackSourceSettings) {
            this.trackSourceSettings = trackSourceSettings;
            return this;
        }

        public final WebvttHlsSourceSettings.Builder getWebvttHlsSourceSettings() {
            return this.webvttHlsSourceSettings != null ? this.webvttHlsSourceSettings.toBuilder() : null;
        }

        public final void setWebvttHlsSourceSettings(WebvttHlsSourceSettings.BuilderImpl webvttHlsSourceSettings) {
            this.webvttHlsSourceSettings = webvttHlsSourceSettings != null ? webvttHlsSourceSettings.build() : null;
        }

        @Override
        public final Builder webvttHlsSourceSettings(WebvttHlsSourceSettings webvttHlsSourceSettings) {
            this.webvttHlsSourceSettings = webvttHlsSourceSettings;
            return this;
        }

        public CaptionSourceSettings build() {
            return new CaptionSourceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaptionSourceSettings> {
        public Builder ancillarySourceSettings(AncillarySourceSettings var1);

        default public Builder ancillarySourceSettings(Consumer<AncillarySourceSettings.Builder> ancillarySourceSettings) {
            return this.ancillarySourceSettings((AncillarySourceSettings)((AncillarySourceSettings.Builder)AncillarySourceSettings.builder().applyMutation(ancillarySourceSettings)).build());
        }

        public Builder dvbSubSourceSettings(DvbSubSourceSettings var1);

        default public Builder dvbSubSourceSettings(Consumer<DvbSubSourceSettings.Builder> dvbSubSourceSettings) {
            return this.dvbSubSourceSettings((DvbSubSourceSettings)((DvbSubSourceSettings.Builder)DvbSubSourceSettings.builder().applyMutation(dvbSubSourceSettings)).build());
        }

        public Builder embeddedSourceSettings(EmbeddedSourceSettings var1);

        default public Builder embeddedSourceSettings(Consumer<EmbeddedSourceSettings.Builder> embeddedSourceSettings) {
            return this.embeddedSourceSettings((EmbeddedSourceSettings)((EmbeddedSourceSettings.Builder)EmbeddedSourceSettings.builder().applyMutation(embeddedSourceSettings)).build());
        }

        public Builder fileSourceSettings(FileSourceSettings var1);

        default public Builder fileSourceSettings(Consumer<FileSourceSettings.Builder> fileSourceSettings) {
            return this.fileSourceSettings((FileSourceSettings)((FileSourceSettings.Builder)FileSourceSettings.builder().applyMutation(fileSourceSettings)).build());
        }

        public Builder sourceType(String var1);

        public Builder sourceType(CaptionSourceType var1);

        public Builder teletextSourceSettings(TeletextSourceSettings var1);

        default public Builder teletextSourceSettings(Consumer<TeletextSourceSettings.Builder> teletextSourceSettings) {
            return this.teletextSourceSettings((TeletextSourceSettings)((TeletextSourceSettings.Builder)TeletextSourceSettings.builder().applyMutation(teletextSourceSettings)).build());
        }

        public Builder trackSourceSettings(TrackSourceSettings var1);

        default public Builder trackSourceSettings(Consumer<TrackSourceSettings.Builder> trackSourceSettings) {
            return this.trackSourceSettings((TrackSourceSettings)((TrackSourceSettings.Builder)TrackSourceSettings.builder().applyMutation(trackSourceSettings)).build());
        }

        public Builder webvttHlsSourceSettings(WebvttHlsSourceSettings var1);

        default public Builder webvttHlsSourceSettings(Consumer<WebvttHlsSourceSettings.Builder> webvttHlsSourceSettings) {
            return this.webvttHlsSourceSettings((WebvttHlsSourceSettings)((WebvttHlsSourceSettings.Builder)WebvttHlsSourceSettings.builder().applyMutation(webvttHlsSourceSettings)).build());
        }
    }
}

