/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AfdSignaling;
import software.amazon.awssdk.services.mediaconvert.model.AntiAlias;
import software.amazon.awssdk.services.mediaconvert.model.ChromaPositionMode;
import software.amazon.awssdk.services.mediaconvert.model.ColorMetadata;
import software.amazon.awssdk.services.mediaconvert.model.DropFrameTimecode;
import software.amazon.awssdk.services.mediaconvert.model.Rectangle;
import software.amazon.awssdk.services.mediaconvert.model.RespondToAfd;
import software.amazon.awssdk.services.mediaconvert.model.ScalingBehavior;
import software.amazon.awssdk.services.mediaconvert.model.TimecodeTrack;
import software.amazon.awssdk.services.mediaconvert.model.VideoCodecSettings;
import software.amazon.awssdk.services.mediaconvert.model.VideoPreprocessor;
import software.amazon.awssdk.services.mediaconvert.model.VideoTimecodeInsertion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoDescription> {
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfdSignaling").getter(VideoDescription.getter(VideoDescription::afdSignalingAsString)).setter(VideoDescription.setter(Builder::afdSignaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()}).build();
    private static final SdkField<String> ANTI_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AntiAlias").getter(VideoDescription.getter(VideoDescription::antiAliasAsString)).setter(VideoDescription.setter(Builder::antiAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antiAlias").build()}).build();
    private static final SdkField<String> CHROMA_POSITION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChromaPositionMode").getter(VideoDescription.getter(VideoDescription::chromaPositionModeAsString)).setter(VideoDescription.setter(Builder::chromaPositionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chromaPositionMode").build()}).build();
    private static final SdkField<VideoCodecSettings> CODEC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodecSettings").getter(VideoDescription.getter(VideoDescription::codecSettings)).setter(VideoDescription.setter(Builder::codecSettings)).constructor(VideoCodecSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSettings").build()}).build();
    private static final SdkField<String> COLOR_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorMetadata").getter(VideoDescription.getter(VideoDescription::colorMetadataAsString)).setter(VideoDescription.setter(Builder::colorMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorMetadata").build()}).build();
    private static final SdkField<Rectangle> CROP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Crop").getter(VideoDescription.getter(VideoDescription::crop)).setter(VideoDescription.setter(Builder::crop)).constructor(Rectangle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crop").build()}).build();
    private static final SdkField<String> DROP_FRAME_TIMECODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DropFrameTimecode").getter(VideoDescription.getter(VideoDescription::dropFrameTimecodeAsString)).setter(VideoDescription.setter(Builder::dropFrameTimecode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dropFrameTimecode").build()}).build();
    private static final SdkField<Integer> FIXED_AFD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FixedAfd").getter(VideoDescription.getter(VideoDescription::fixedAfd)).setter(VideoDescription.setter(Builder::fixedAfd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()}).build();
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Height").getter(VideoDescription.getter(VideoDescription::height)).setter(VideoDescription.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()}).build();
    private static final SdkField<Rectangle> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Position").getter(VideoDescription.getter(VideoDescription::position)).setter(VideoDescription.setter(Builder::position)).constructor(Rectangle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<String> RESPOND_TO_AFD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RespondToAfd").getter(VideoDescription.getter(VideoDescription::respondToAfdAsString)).setter(VideoDescription.setter(Builder::respondToAfd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("respondToAfd").build()}).build();
    private static final SdkField<String> SCALING_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingBehavior").getter(VideoDescription.getter(VideoDescription::scalingBehaviorAsString)).setter(VideoDescription.setter(Builder::scalingBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingBehavior").build()}).build();
    private static final SdkField<Integer> SHARPNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Sharpness").getter(VideoDescription.getter(VideoDescription::sharpness)).setter(VideoDescription.setter(Builder::sharpness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharpness").build()}).build();
    private static final SdkField<String> TIMECODE_INSERTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimecodeInsertion").getter(VideoDescription.getter(VideoDescription::timecodeInsertionAsString)).setter(VideoDescription.setter(Builder::timecodeInsertion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeInsertion").build()}).build();
    private static final SdkField<String> TIMECODE_TRACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimecodeTrack").getter(VideoDescription.getter(VideoDescription::timecodeTrackAsString)).setter(VideoDescription.setter(Builder::timecodeTrack)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeTrack").build()}).build();
    private static final SdkField<VideoPreprocessor> VIDEO_PREPROCESSORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoPreprocessors").getter(VideoDescription.getter(VideoDescription::videoPreprocessors)).setter(VideoDescription.setter(Builder::videoPreprocessors)).constructor(VideoPreprocessor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoPreprocessors").build()}).build();
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Width").getter(VideoDescription.getter(VideoDescription::width)).setter(VideoDescription.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFD_SIGNALING_FIELD, ANTI_ALIAS_FIELD, CHROMA_POSITION_MODE_FIELD, CODEC_SETTINGS_FIELD, COLOR_METADATA_FIELD, CROP_FIELD, DROP_FRAME_TIMECODE_FIELD, FIXED_AFD_FIELD, HEIGHT_FIELD, POSITION_FIELD, RESPOND_TO_AFD_FIELD, SCALING_BEHAVIOR_FIELD, SHARPNESS_FIELD, TIMECODE_INSERTION_FIELD, TIMECODE_TRACK_FIELD, VIDEO_PREPROCESSORS_FIELD, WIDTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String afdSignaling;
    private final String antiAlias;
    private final String chromaPositionMode;
    private final VideoCodecSettings codecSettings;
    private final String colorMetadata;
    private final Rectangle crop;
    private final String dropFrameTimecode;
    private final Integer fixedAfd;
    private final Integer height;
    private final Rectangle position;
    private final String respondToAfd;
    private final String scalingBehavior;
    private final Integer sharpness;
    private final String timecodeInsertion;
    private final String timecodeTrack;
    private final VideoPreprocessor videoPreprocessors;
    private final Integer width;

    private VideoDescription(BuilderImpl builder) {
        this.afdSignaling = builder.afdSignaling;
        this.antiAlias = builder.antiAlias;
        this.chromaPositionMode = builder.chromaPositionMode;
        this.codecSettings = builder.codecSettings;
        this.colorMetadata = builder.colorMetadata;
        this.crop = builder.crop;
        this.dropFrameTimecode = builder.dropFrameTimecode;
        this.fixedAfd = builder.fixedAfd;
        this.height = builder.height;
        this.position = builder.position;
        this.respondToAfd = builder.respondToAfd;
        this.scalingBehavior = builder.scalingBehavior;
        this.sharpness = builder.sharpness;
        this.timecodeInsertion = builder.timecodeInsertion;
        this.timecodeTrack = builder.timecodeTrack;
        this.videoPreprocessors = builder.videoPreprocessors;
        this.width = builder.width;
    }

    public final AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(this.afdSignaling);
    }

    public final String afdSignalingAsString() {
        return this.afdSignaling;
    }

    public final AntiAlias antiAlias() {
        return AntiAlias.fromValue(this.antiAlias);
    }

    public final String antiAliasAsString() {
        return this.antiAlias;
    }

    public final ChromaPositionMode chromaPositionMode() {
        return ChromaPositionMode.fromValue(this.chromaPositionMode);
    }

    public final String chromaPositionModeAsString() {
        return this.chromaPositionMode;
    }

    public final VideoCodecSettings codecSettings() {
        return this.codecSettings;
    }

    public final ColorMetadata colorMetadata() {
        return ColorMetadata.fromValue(this.colorMetadata);
    }

    public final String colorMetadataAsString() {
        return this.colorMetadata;
    }

    public final Rectangle crop() {
        return this.crop;
    }

    public final DropFrameTimecode dropFrameTimecode() {
        return DropFrameTimecode.fromValue(this.dropFrameTimecode);
    }

    public final String dropFrameTimecodeAsString() {
        return this.dropFrameTimecode;
    }

    public final Integer fixedAfd() {
        return this.fixedAfd;
    }

    public final Integer height() {
        return this.height;
    }

    public final Rectangle position() {
        return this.position;
    }

    public final RespondToAfd respondToAfd() {
        return RespondToAfd.fromValue(this.respondToAfd);
    }

    public final String respondToAfdAsString() {
        return this.respondToAfd;
    }

    public final ScalingBehavior scalingBehavior() {
        return ScalingBehavior.fromValue(this.scalingBehavior);
    }

    public final String scalingBehaviorAsString() {
        return this.scalingBehavior;
    }

    public final Integer sharpness() {
        return this.sharpness;
    }

    public final VideoTimecodeInsertion timecodeInsertion() {
        return VideoTimecodeInsertion.fromValue(this.timecodeInsertion);
    }

    public final String timecodeInsertionAsString() {
        return this.timecodeInsertion;
    }

    public final TimecodeTrack timecodeTrack() {
        return TimecodeTrack.fromValue(this.timecodeTrack);
    }

    public final String timecodeTrackAsString() {
        return this.timecodeTrack;
    }

    public final VideoPreprocessor videoPreprocessors() {
        return this.videoPreprocessors;
    }

    public final Integer width() {
        return this.width;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.antiAliasAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.chromaPositionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorMetadataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.crop());
        hashCode = 31 * hashCode + Objects.hashCode(this.dropFrameTimecodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedAfd());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.respondToAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharpness());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeInsertionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeTrackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoPreprocessors());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoDescription)) {
            return false;
        }
        VideoDescription other = (VideoDescription)obj;
        return Objects.equals(this.afdSignalingAsString(), other.afdSignalingAsString()) && Objects.equals(this.antiAliasAsString(), other.antiAliasAsString()) && Objects.equals(this.chromaPositionModeAsString(), other.chromaPositionModeAsString()) && Objects.equals(this.codecSettings(), other.codecSettings()) && Objects.equals(this.colorMetadataAsString(), other.colorMetadataAsString()) && Objects.equals(this.crop(), other.crop()) && Objects.equals(this.dropFrameTimecodeAsString(), other.dropFrameTimecodeAsString()) && Objects.equals(this.fixedAfd(), other.fixedAfd()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.respondToAfdAsString(), other.respondToAfdAsString()) && Objects.equals(this.scalingBehaviorAsString(), other.scalingBehaviorAsString()) && Objects.equals(this.sharpness(), other.sharpness()) && Objects.equals(this.timecodeInsertionAsString(), other.timecodeInsertionAsString()) && Objects.equals(this.timecodeTrackAsString(), other.timecodeTrackAsString()) && Objects.equals(this.videoPreprocessors(), other.videoPreprocessors()) && Objects.equals(this.width(), other.width());
    }

    public final String toString() {
        return ToString.builder((String)"VideoDescription").add("AfdSignaling", (Object)this.afdSignalingAsString()).add("AntiAlias", (Object)this.antiAliasAsString()).add("ChromaPositionMode", (Object)this.chromaPositionModeAsString()).add("CodecSettings", (Object)this.codecSettings()).add("ColorMetadata", (Object)this.colorMetadataAsString()).add("Crop", (Object)this.crop()).add("DropFrameTimecode", (Object)this.dropFrameTimecodeAsString()).add("FixedAfd", (Object)this.fixedAfd()).add("Height", (Object)this.height()).add("Position", (Object)this.position()).add("RespondToAfd", (Object)this.respondToAfdAsString()).add("ScalingBehavior", (Object)this.scalingBehaviorAsString()).add("Sharpness", (Object)this.sharpness()).add("TimecodeInsertion", (Object)this.timecodeInsertionAsString()).add("TimecodeTrack", (Object)this.timecodeTrackAsString()).add("VideoPreprocessors", (Object)this.videoPreprocessors()).add("Width", (Object)this.width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AfdSignaling": {
                return Optional.ofNullable(clazz.cast(this.afdSignalingAsString()));
            }
            case "AntiAlias": {
                return Optional.ofNullable(clazz.cast(this.antiAliasAsString()));
            }
            case "ChromaPositionMode": {
                return Optional.ofNullable(clazz.cast(this.chromaPositionModeAsString()));
            }
            case "CodecSettings": {
                return Optional.ofNullable(clazz.cast(this.codecSettings()));
            }
            case "ColorMetadata": {
                return Optional.ofNullable(clazz.cast(this.colorMetadataAsString()));
            }
            case "Crop": {
                return Optional.ofNullable(clazz.cast(this.crop()));
            }
            case "DropFrameTimecode": {
                return Optional.ofNullable(clazz.cast(this.dropFrameTimecodeAsString()));
            }
            case "FixedAfd": {
                return Optional.ofNullable(clazz.cast(this.fixedAfd()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "RespondToAfd": {
                return Optional.ofNullable(clazz.cast(this.respondToAfdAsString()));
            }
            case "ScalingBehavior": {
                return Optional.ofNullable(clazz.cast(this.scalingBehaviorAsString()));
            }
            case "Sharpness": {
                return Optional.ofNullable(clazz.cast(this.sharpness()));
            }
            case "TimecodeInsertion": {
                return Optional.ofNullable(clazz.cast(this.timecodeInsertionAsString()));
            }
            case "TimecodeTrack": {
                return Optional.ofNullable(clazz.cast(this.timecodeTrackAsString()));
            }
            case "VideoPreprocessors": {
                return Optional.ofNullable(clazz.cast(this.videoPreprocessors()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("afdSignaling", AFD_SIGNALING_FIELD);
        map.put("antiAlias", ANTI_ALIAS_FIELD);
        map.put("chromaPositionMode", CHROMA_POSITION_MODE_FIELD);
        map.put("codecSettings", CODEC_SETTINGS_FIELD);
        map.put("colorMetadata", COLOR_METADATA_FIELD);
        map.put("crop", CROP_FIELD);
        map.put("dropFrameTimecode", DROP_FRAME_TIMECODE_FIELD);
        map.put("fixedAfd", FIXED_AFD_FIELD);
        map.put("height", HEIGHT_FIELD);
        map.put("position", POSITION_FIELD);
        map.put("respondToAfd", RESPOND_TO_AFD_FIELD);
        map.put("scalingBehavior", SCALING_BEHAVIOR_FIELD);
        map.put("sharpness", SHARPNESS_FIELD);
        map.put("timecodeInsertion", TIMECODE_INSERTION_FIELD);
        map.put("timecodeTrack", TIMECODE_TRACK_FIELD);
        map.put("videoPreprocessors", VIDEO_PREPROCESSORS_FIELD);
        map.put("width", WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoDescription, T> g) {
        return obj -> g.apply((VideoDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String afdSignaling;
        private String antiAlias;
        private String chromaPositionMode;
        private VideoCodecSettings codecSettings;
        private String colorMetadata;
        private Rectangle crop;
        private String dropFrameTimecode;
        private Integer fixedAfd;
        private Integer height;
        private Rectangle position;
        private String respondToAfd;
        private String scalingBehavior;
        private Integer sharpness;
        private String timecodeInsertion;
        private String timecodeTrack;
        private VideoPreprocessor videoPreprocessors;
        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoDescription model) {
            this.afdSignaling(model.afdSignaling);
            this.antiAlias(model.antiAlias);
            this.chromaPositionMode(model.chromaPositionMode);
            this.codecSettings(model.codecSettings);
            this.colorMetadata(model.colorMetadata);
            this.crop(model.crop);
            this.dropFrameTimecode(model.dropFrameTimecode);
            this.fixedAfd(model.fixedAfd);
            this.height(model.height);
            this.position(model.position);
            this.respondToAfd(model.respondToAfd);
            this.scalingBehavior(model.scalingBehavior);
            this.sharpness(model.sharpness);
            this.timecodeInsertion(model.timecodeInsertion);
            this.timecodeTrack(model.timecodeTrack);
            this.videoPreprocessors(model.videoPreprocessors);
            this.width(model.width);
        }

        public final String getAfdSignaling() {
            return this.afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final String getAntiAlias() {
            return this.antiAlias;
        }

        public final void setAntiAlias(String antiAlias) {
            this.antiAlias = antiAlias;
        }

        @Override
        public final Builder antiAlias(String antiAlias) {
            this.antiAlias = antiAlias;
            return this;
        }

        @Override
        public final Builder antiAlias(AntiAlias antiAlias) {
            this.antiAlias(antiAlias == null ? null : antiAlias.toString());
            return this;
        }

        public final String getChromaPositionMode() {
            return this.chromaPositionMode;
        }

        public final void setChromaPositionMode(String chromaPositionMode) {
            this.chromaPositionMode = chromaPositionMode;
        }

        @Override
        public final Builder chromaPositionMode(String chromaPositionMode) {
            this.chromaPositionMode = chromaPositionMode;
            return this;
        }

        @Override
        public final Builder chromaPositionMode(ChromaPositionMode chromaPositionMode) {
            this.chromaPositionMode(chromaPositionMode == null ? null : chromaPositionMode.toString());
            return this;
        }

        public final VideoCodecSettings.Builder getCodecSettings() {
            return this.codecSettings != null ? this.codecSettings.toBuilder() : null;
        }

        public final void setCodecSettings(VideoCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        @Override
        public final Builder codecSettings(VideoCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final String getColorMetadata() {
            return this.colorMetadata;
        }

        public final void setColorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
        }

        @Override
        public final Builder colorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
            return this;
        }

        @Override
        public final Builder colorMetadata(ColorMetadata colorMetadata) {
            this.colorMetadata(colorMetadata == null ? null : colorMetadata.toString());
            return this;
        }

        public final Rectangle.Builder getCrop() {
            return this.crop != null ? this.crop.toBuilder() : null;
        }

        public final void setCrop(Rectangle.BuilderImpl crop) {
            this.crop = crop != null ? crop.build() : null;
        }

        @Override
        public final Builder crop(Rectangle crop) {
            this.crop = crop;
            return this;
        }

        public final String getDropFrameTimecode() {
            return this.dropFrameTimecode;
        }

        public final void setDropFrameTimecode(String dropFrameTimecode) {
            this.dropFrameTimecode = dropFrameTimecode;
        }

        @Override
        public final Builder dropFrameTimecode(String dropFrameTimecode) {
            this.dropFrameTimecode = dropFrameTimecode;
            return this;
        }

        @Override
        public final Builder dropFrameTimecode(DropFrameTimecode dropFrameTimecode) {
            this.dropFrameTimecode(dropFrameTimecode == null ? null : dropFrameTimecode.toString());
            return this;
        }

        public final Integer getFixedAfd() {
            return this.fixedAfd;
        }

        public final void setFixedAfd(Integer fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        @Override
        public final Builder fixedAfd(Integer fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        public final Integer getHeight() {
            return this.height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final Rectangle.Builder getPosition() {
            return this.position != null ? this.position.toBuilder() : null;
        }

        public final void setPosition(Rectangle.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(Rectangle position) {
            this.position = position;
            return this;
        }

        public final String getRespondToAfd() {
            return this.respondToAfd;
        }

        public final void setRespondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
        }

        @Override
        public final Builder respondToAfd(String respondToAfd) {
            this.respondToAfd = respondToAfd;
            return this;
        }

        @Override
        public final Builder respondToAfd(RespondToAfd respondToAfd) {
            this.respondToAfd(respondToAfd == null ? null : respondToAfd.toString());
            return this;
        }

        public final String getScalingBehavior() {
            return this.scalingBehavior;
        }

        public final void setScalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
        }

        @Override
        public final Builder scalingBehavior(String scalingBehavior) {
            this.scalingBehavior = scalingBehavior;
            return this;
        }

        @Override
        public final Builder scalingBehavior(ScalingBehavior scalingBehavior) {
            this.scalingBehavior(scalingBehavior == null ? null : scalingBehavior.toString());
            return this;
        }

        public final Integer getSharpness() {
            return this.sharpness;
        }

        public final void setSharpness(Integer sharpness) {
            this.sharpness = sharpness;
        }

        @Override
        public final Builder sharpness(Integer sharpness) {
            this.sharpness = sharpness;
            return this;
        }

        public final String getTimecodeInsertion() {
            return this.timecodeInsertion;
        }

        public final void setTimecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
        }

        @Override
        public final Builder timecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
            return this;
        }

        @Override
        public final Builder timecodeInsertion(VideoTimecodeInsertion timecodeInsertion) {
            this.timecodeInsertion(timecodeInsertion == null ? null : timecodeInsertion.toString());
            return this;
        }

        public final String getTimecodeTrack() {
            return this.timecodeTrack;
        }

        public final void setTimecodeTrack(String timecodeTrack) {
            this.timecodeTrack = timecodeTrack;
        }

        @Override
        public final Builder timecodeTrack(String timecodeTrack) {
            this.timecodeTrack = timecodeTrack;
            return this;
        }

        @Override
        public final Builder timecodeTrack(TimecodeTrack timecodeTrack) {
            this.timecodeTrack(timecodeTrack == null ? null : timecodeTrack.toString());
            return this;
        }

        public final VideoPreprocessor.Builder getVideoPreprocessors() {
            return this.videoPreprocessors != null ? this.videoPreprocessors.toBuilder() : null;
        }

        public final void setVideoPreprocessors(VideoPreprocessor.BuilderImpl videoPreprocessors) {
            this.videoPreprocessors = videoPreprocessors != null ? videoPreprocessors.build() : null;
        }

        @Override
        public final Builder videoPreprocessors(VideoPreprocessor videoPreprocessors) {
            this.videoPreprocessors = videoPreprocessors;
            return this;
        }

        public final Integer getWidth() {
            return this.width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public VideoDescription build() {
            return new VideoDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoDescription> {
        public Builder afdSignaling(String var1);

        public Builder afdSignaling(AfdSignaling var1);

        public Builder antiAlias(String var1);

        public Builder antiAlias(AntiAlias var1);

        public Builder chromaPositionMode(String var1);

        public Builder chromaPositionMode(ChromaPositionMode var1);

        public Builder codecSettings(VideoCodecSettings var1);

        default public Builder codecSettings(Consumer<VideoCodecSettings.Builder> codecSettings) {
            return this.codecSettings((VideoCodecSettings)((VideoCodecSettings.Builder)VideoCodecSettings.builder().applyMutation(codecSettings)).build());
        }

        public Builder colorMetadata(String var1);

        public Builder colorMetadata(ColorMetadata var1);

        public Builder crop(Rectangle var1);

        default public Builder crop(Consumer<Rectangle.Builder> crop) {
            return this.crop((Rectangle)((Rectangle.Builder)Rectangle.builder().applyMutation(crop)).build());
        }

        public Builder dropFrameTimecode(String var1);

        public Builder dropFrameTimecode(DropFrameTimecode var1);

        public Builder fixedAfd(Integer var1);

        public Builder height(Integer var1);

        public Builder position(Rectangle var1);

        default public Builder position(Consumer<Rectangle.Builder> position) {
            return this.position((Rectangle)((Rectangle.Builder)Rectangle.builder().applyMutation(position)).build());
        }

        public Builder respondToAfd(String var1);

        public Builder respondToAfd(RespondToAfd var1);

        public Builder scalingBehavior(String var1);

        public Builder scalingBehavior(ScalingBehavior var1);

        public Builder sharpness(Integer var1);

        public Builder timecodeInsertion(String var1);

        public Builder timecodeInsertion(VideoTimecodeInsertion var1);

        public Builder timecodeTrack(String var1);

        public Builder timecodeTrack(TimecodeTrack var1);

        public Builder videoPreprocessors(VideoPreprocessor var1);

        default public Builder videoPreprocessors(Consumer<VideoPreprocessor.Builder> videoPreprocessors) {
            return this.videoPreprocessors((VideoPreprocessor)((VideoPreprocessor.Builder)VideoPreprocessor.builder().applyMutation(videoPreprocessors)).build());
        }

        public Builder width(Integer var1);
    }
}

