/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.FrameMetricType;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2AdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2CodecLevel;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2CodecProfile;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2DynamicSubGop;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2FramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2FramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2GopSizeUnits;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2InterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2IntraDcPrecision;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2ParControl;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2QualityTuningLevel;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2RateControlMode;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2ScanTypeConversionMode;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2SceneChangeDetect;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2SlowPal;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2SpatialAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2Syntax;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2Telecine;
import software.amazon.awssdk.services.mediaconvert.model.Mpeg2TemporalAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.___listOfFrameMetricTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Mpeg2Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Mpeg2Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdaptiveQuantization").getter(Mpeg2Settings.getter(Mpeg2Settings::adaptiveQuantizationAsString)).setter(Mpeg2Settings.setter(Builder::adaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build()}).build();
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bitrate").getter(Mpeg2Settings.getter(Mpeg2Settings::bitrate)).setter(Mpeg2Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> CODEC_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodecLevel").getter(Mpeg2Settings.getter(Mpeg2Settings::codecLevelAsString)).setter(Mpeg2Settings.setter(Builder::codecLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecLevel").build()}).build();
    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodecProfile").getter(Mpeg2Settings.getter(Mpeg2Settings::codecProfileAsString)).setter(Mpeg2Settings.setter(Builder::codecProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()}).build();
    private static final SdkField<String> DYNAMIC_SUB_GOP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamicSubGop").getter(Mpeg2Settings.getter(Mpeg2Settings::dynamicSubGopAsString)).setter(Mpeg2Settings.setter(Builder::dynamicSubGop)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicSubGop").build()}).build();
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateControl").getter(Mpeg2Settings.getter(Mpeg2Settings::framerateControlAsString)).setter(Mpeg2Settings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateConversionAlgorithm").getter(Mpeg2Settings.getter(Mpeg2Settings::framerateConversionAlgorithmAsString)).setter(Mpeg2Settings.setter(Builder::framerateConversionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(Mpeg2Settings.getter(Mpeg2Settings::framerateDenominator)).setter(Mpeg2Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(Mpeg2Settings.getter(Mpeg2Settings::framerateNumerator)).setter(Mpeg2Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GopClosedCadence").getter(Mpeg2Settings.getter(Mpeg2Settings::gopClosedCadence)).setter(Mpeg2Settings.setter(Builder::gopClosedCadence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()}).build();
    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("GopSize").getter(Mpeg2Settings.getter(Mpeg2Settings::gopSize)).setter(Mpeg2Settings.setter(Builder::gopSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()}).build();
    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GopSizeUnits").getter(Mpeg2Settings.getter(Mpeg2Settings::gopSizeUnitsAsString)).setter(Mpeg2Settings.setter(Builder::gopSizeUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()}).build();
    private static final SdkField<Integer> HRD_BUFFER_FINAL_FILL_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HrdBufferFinalFillPercentage").getter(Mpeg2Settings.getter(Mpeg2Settings::hrdBufferFinalFillPercentage)).setter(Mpeg2Settings.setter(Builder::hrdBufferFinalFillPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferFinalFillPercentage").build()}).build();
    private static final SdkField<Integer> HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HrdBufferInitialFillPercentage").getter(Mpeg2Settings.getter(Mpeg2Settings::hrdBufferInitialFillPercentage)).setter(Mpeg2Settings.setter(Builder::hrdBufferInitialFillPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferInitialFillPercentage").build()}).build();
    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HrdBufferSize").getter(Mpeg2Settings.getter(Mpeg2Settings::hrdBufferSize)).setter(Mpeg2Settings.setter(Builder::hrdBufferSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()}).build();
    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterlaceMode").getter(Mpeg2Settings.getter(Mpeg2Settings::interlaceModeAsString)).setter(Mpeg2Settings.setter(Builder::interlaceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()}).build();
    private static final SdkField<String> INTRA_DC_PRECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntraDcPrecision").getter(Mpeg2Settings.getter(Mpeg2Settings::intraDcPrecisionAsString)).setter(Mpeg2Settings.setter(Builder::intraDcPrecision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intraDcPrecision").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(Mpeg2Settings.getter(Mpeg2Settings::maxBitrate)).setter(Mpeg2Settings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinIInterval").getter(Mpeg2Settings.getter(Mpeg2Settings::minIInterval)).setter(Mpeg2Settings.setter(Builder::minIInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()}).build();
    private static final SdkField<Integer> NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberBFramesBetweenReferenceFrames").getter(Mpeg2Settings.getter(Mpeg2Settings::numberBFramesBetweenReferenceFrames)).setter(Mpeg2Settings.setter(Builder::numberBFramesBetweenReferenceFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberBFramesBetweenReferenceFrames").build()}).build();
    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParControl").getter(Mpeg2Settings.getter(Mpeg2Settings::parControlAsString)).setter(Mpeg2Settings.setter(Builder::parControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()}).build();
    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParDenominator").getter(Mpeg2Settings.getter(Mpeg2Settings::parDenominator)).setter(Mpeg2Settings.setter(Builder::parDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()}).build();
    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParNumerator").getter(Mpeg2Settings.getter(Mpeg2Settings::parNumerator)).setter(Mpeg2Settings.setter(Builder::parNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()}).build();
    private static final SdkField<List<String>> PER_FRAME_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PerFrameMetrics").getter(Mpeg2Settings.getter(Mpeg2Settings::perFrameMetricsAsStrings)).setter(Mpeg2Settings.setter(Builder::perFrameMetricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("perFrameMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QualityTuningLevel").getter(Mpeg2Settings.getter(Mpeg2Settings::qualityTuningLevelAsString)).setter(Mpeg2Settings.setter(Builder::qualityTuningLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RateControlMode").getter(Mpeg2Settings.getter(Mpeg2Settings::rateControlModeAsString)).setter(Mpeg2Settings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final SdkField<String> SCAN_TYPE_CONVERSION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanTypeConversionMode").getter(Mpeg2Settings.getter(Mpeg2Settings::scanTypeConversionModeAsString)).setter(Mpeg2Settings.setter(Builder::scanTypeConversionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanTypeConversionMode").build()}).build();
    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SceneChangeDetect").getter(Mpeg2Settings.getter(Mpeg2Settings::sceneChangeDetectAsString)).setter(Mpeg2Settings.setter(Builder::sceneChangeDetect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()}).build();
    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlowPal").getter(Mpeg2Settings.getter(Mpeg2Settings::slowPalAsString)).setter(Mpeg2Settings.setter(Builder::slowPal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()}).build();
    private static final SdkField<Integer> SOFTNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Softness").getter(Mpeg2Settings.getter(Mpeg2Settings::softness)).setter(Mpeg2Settings.setter(Builder::softness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softness").build()}).build();
    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpatialAdaptiveQuantization").getter(Mpeg2Settings.getter(Mpeg2Settings::spatialAdaptiveQuantizationAsString)).setter(Mpeg2Settings.setter(Builder::spatialAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization").build()}).build();
    private static final SdkField<String> SYNTAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Syntax").getter(Mpeg2Settings.getter(Mpeg2Settings::syntaxAsString)).setter(Mpeg2Settings.setter(Builder::syntax)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntax").build()}).build();
    private static final SdkField<String> TELECINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Telecine").getter(Mpeg2Settings.getter(Mpeg2Settings::telecineAsString)).setter(Mpeg2Settings.setter(Builder::telecine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()}).build();
    private static final SdkField<String> TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemporalAdaptiveQuantization").getter(Mpeg2Settings.getter(Mpeg2Settings::temporalAdaptiveQuantizationAsString)).setter(Mpeg2Settings.setter(Builder::temporalAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAdaptiveQuantization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD, BITRATE_FIELD, CODEC_LEVEL_FIELD, CODEC_PROFILE_FIELD, DYNAMIC_SUB_GOP_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_CLOSED_CADENCE_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, HRD_BUFFER_FINAL_FILL_PERCENTAGE_FIELD, HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD, HRD_BUFFER_SIZE_FIELD, INTERLACE_MODE_FIELD, INTRA_DC_PRECISION_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD, NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD, PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, PER_FRAME_METRICS_FIELD, QUALITY_TUNING_LEVEL_FIELD, RATE_CONTROL_MODE_FIELD, SCAN_TYPE_CONVERSION_MODE_FIELD, SCENE_CHANGE_DETECT_FIELD, SLOW_PAL_FIELD, SOFTNESS_FIELD, SPATIAL_ADAPTIVE_QUANTIZATION_FIELD, SYNTAX_FIELD, TELECINE_FIELD, TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Mpeg2Settings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String adaptiveQuantization;
    private final Integer bitrate;
    private final String codecLevel;
    private final String codecProfile;
    private final String dynamicSubGop;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final Integer gopClosedCadence;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final Integer hrdBufferFinalFillPercentage;
    private final Integer hrdBufferInitialFillPercentage;
    private final Integer hrdBufferSize;
    private final String interlaceMode;
    private final String intraDcPrecision;
    private final Integer maxBitrate;
    private final Integer minIInterval;
    private final Integer numberBFramesBetweenReferenceFrames;
    private final String parControl;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final List<String> perFrameMetrics;
    private final String qualityTuningLevel;
    private final String rateControlMode;
    private final String scanTypeConversionMode;
    private final String sceneChangeDetect;
    private final String slowPal;
    private final Integer softness;
    private final String spatialAdaptiveQuantization;
    private final String syntax;
    private final String telecine;
    private final String temporalAdaptiveQuantization;

    private Mpeg2Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.bitrate = builder.bitrate;
        this.codecLevel = builder.codecLevel;
        this.codecProfile = builder.codecProfile;
        this.dynamicSubGop = builder.dynamicSubGop;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.hrdBufferFinalFillPercentage = builder.hrdBufferFinalFillPercentage;
        this.hrdBufferInitialFillPercentage = builder.hrdBufferInitialFillPercentage;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.intraDcPrecision = builder.intraDcPrecision;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.perFrameMetrics = builder.perFrameMetrics;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.rateControlMode = builder.rateControlMode;
        this.scanTypeConversionMode = builder.scanTypeConversionMode;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slowPal = builder.slowPal;
        this.softness = builder.softness;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.syntax = builder.syntax;
        this.telecine = builder.telecine;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
    }

    public final Mpeg2AdaptiveQuantization adaptiveQuantization() {
        return Mpeg2AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public final String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public final Integer bitrate() {
        return this.bitrate;
    }

    public final Mpeg2CodecLevel codecLevel() {
        return Mpeg2CodecLevel.fromValue(this.codecLevel);
    }

    public final String codecLevelAsString() {
        return this.codecLevel;
    }

    public final Mpeg2CodecProfile codecProfile() {
        return Mpeg2CodecProfile.fromValue(this.codecProfile);
    }

    public final String codecProfileAsString() {
        return this.codecProfile;
    }

    public final Mpeg2DynamicSubGop dynamicSubGop() {
        return Mpeg2DynamicSubGop.fromValue(this.dynamicSubGop);
    }

    public final String dynamicSubGopAsString() {
        return this.dynamicSubGop;
    }

    public final Mpeg2FramerateControl framerateControl() {
        return Mpeg2FramerateControl.fromValue(this.framerateControl);
    }

    public final String framerateControlAsString() {
        return this.framerateControl;
    }

    public final Mpeg2FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return Mpeg2FramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public final String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public final Double gopSize() {
        return this.gopSize;
    }

    public final Mpeg2GopSizeUnits gopSizeUnits() {
        return Mpeg2GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public final String gopSizeUnitsAsString() {
        return this.gopSizeUnits;
    }

    public final Integer hrdBufferFinalFillPercentage() {
        return this.hrdBufferFinalFillPercentage;
    }

    public final Integer hrdBufferInitialFillPercentage() {
        return this.hrdBufferInitialFillPercentage;
    }

    public final Integer hrdBufferSize() {
        return this.hrdBufferSize;
    }

    public final Mpeg2InterlaceMode interlaceMode() {
        return Mpeg2InterlaceMode.fromValue(this.interlaceMode);
    }

    public final String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public final Mpeg2IntraDcPrecision intraDcPrecision() {
        return Mpeg2IntraDcPrecision.fromValue(this.intraDcPrecision);
    }

    public final String intraDcPrecisionAsString() {
        return this.intraDcPrecision;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final Integer minIInterval() {
        return this.minIInterval;
    }

    public final Integer numberBFramesBetweenReferenceFrames() {
        return this.numberBFramesBetweenReferenceFrames;
    }

    public final Mpeg2ParControl parControl() {
        return Mpeg2ParControl.fromValue(this.parControl);
    }

    public final String parControlAsString() {
        return this.parControl;
    }

    public final Integer parDenominator() {
        return this.parDenominator;
    }

    public final Integer parNumerator() {
        return this.parNumerator;
    }

    public final List<FrameMetricType> perFrameMetrics() {
        return ___listOfFrameMetricTypeCopier.copyStringToEnum(this.perFrameMetrics);
    }

    public final boolean hasPerFrameMetrics() {
        return this.perFrameMetrics != null && !(this.perFrameMetrics instanceof SdkAutoConstructList);
    }

    public final List<String> perFrameMetricsAsStrings() {
        return this.perFrameMetrics;
    }

    public final Mpeg2QualityTuningLevel qualityTuningLevel() {
        return Mpeg2QualityTuningLevel.fromValue(this.qualityTuningLevel);
    }

    public final String qualityTuningLevelAsString() {
        return this.qualityTuningLevel;
    }

    public final Mpeg2RateControlMode rateControlMode() {
        return Mpeg2RateControlMode.fromValue(this.rateControlMode);
    }

    public final String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public final Mpeg2ScanTypeConversionMode scanTypeConversionMode() {
        return Mpeg2ScanTypeConversionMode.fromValue(this.scanTypeConversionMode);
    }

    public final String scanTypeConversionModeAsString() {
        return this.scanTypeConversionMode;
    }

    public final Mpeg2SceneChangeDetect sceneChangeDetect() {
        return Mpeg2SceneChangeDetect.fromValue(this.sceneChangeDetect);
    }

    public final String sceneChangeDetectAsString() {
        return this.sceneChangeDetect;
    }

    public final Mpeg2SlowPal slowPal() {
        return Mpeg2SlowPal.fromValue(this.slowPal);
    }

    public final String slowPalAsString() {
        return this.slowPal;
    }

    public final Integer softness() {
        return this.softness;
    }

    public final Mpeg2SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return Mpeg2SpatialAdaptiveQuantization.fromValue(this.spatialAdaptiveQuantization);
    }

    public final String spatialAdaptiveQuantizationAsString() {
        return this.spatialAdaptiveQuantization;
    }

    public final Mpeg2Syntax syntax() {
        return Mpeg2Syntax.fromValue(this.syntax);
    }

    public final String syntaxAsString() {
        return this.syntax;
    }

    public final Mpeg2Telecine telecine() {
        return Mpeg2Telecine.fromValue(this.telecine);
    }

    public final String telecineAsString() {
        return this.telecine;
    }

    public final Mpeg2TemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return Mpeg2TemporalAdaptiveQuantization.fromValue(this.temporalAdaptiveQuantization);
    }

    public final String temporalAdaptiveQuantizationAsString() {
        return this.temporalAdaptiveQuantization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicSubGopAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferFinalFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferInitialFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.intraDcPrecisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPerFrameMetrics() ? this.perFrameMetricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeConversionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.softness());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syntaxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalAdaptiveQuantizationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mpeg2Settings)) {
            return false;
        }
        Mpeg2Settings other = (Mpeg2Settings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codecLevelAsString(), other.codecLevelAsString()) && Objects.equals(this.codecProfileAsString(), other.codecProfileAsString()) && Objects.equals(this.dynamicSubGopAsString(), other.dynamicSubGopAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsAsString(), other.gopSizeUnitsAsString()) && Objects.equals(this.hrdBufferFinalFillPercentage(), other.hrdBufferFinalFillPercentage()) && Objects.equals(this.hrdBufferInitialFillPercentage(), other.hrdBufferInitialFillPercentage()) && Objects.equals(this.hrdBufferSize(), other.hrdBufferSize()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.intraDcPrecisionAsString(), other.intraDcPrecisionAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.minIInterval(), other.minIInterval()) && Objects.equals(this.numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames()) && Objects.equals(this.parControlAsString(), other.parControlAsString()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && this.hasPerFrameMetrics() == other.hasPerFrameMetrics() && Objects.equals(this.perFrameMetricsAsStrings(), other.perFrameMetricsAsStrings()) && Objects.equals(this.qualityTuningLevelAsString(), other.qualityTuningLevelAsString()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.scanTypeConversionModeAsString(), other.scanTypeConversionModeAsString()) && Objects.equals(this.sceneChangeDetectAsString(), other.sceneChangeDetectAsString()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.softness(), other.softness()) && Objects.equals(this.spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString()) && Objects.equals(this.syntaxAsString(), other.syntaxAsString()) && Objects.equals(this.telecineAsString(), other.telecineAsString()) && Objects.equals(this.temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Mpeg2Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("Bitrate", (Object)this.bitrate()).add("CodecLevel", (Object)this.codecLevelAsString()).add("CodecProfile", (Object)this.codecProfileAsString()).add("DynamicSubGop", (Object)this.dynamicSubGopAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsAsString()).add("HrdBufferFinalFillPercentage", (Object)this.hrdBufferFinalFillPercentage()).add("HrdBufferInitialFillPercentage", (Object)this.hrdBufferInitialFillPercentage()).add("HrdBufferSize", (Object)this.hrdBufferSize()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("IntraDcPrecision", (Object)this.intraDcPrecisionAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("MinIInterval", (Object)this.minIInterval()).add("NumberBFramesBetweenReferenceFrames", (Object)this.numberBFramesBetweenReferenceFrames()).add("ParControl", (Object)this.parControlAsString()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("PerFrameMetrics", this.hasPerFrameMetrics() ? this.perFrameMetricsAsStrings() : null).add("QualityTuningLevel", (Object)this.qualityTuningLevelAsString()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("ScanTypeConversionMode", (Object)this.scanTypeConversionModeAsString()).add("SceneChangeDetect", (Object)this.sceneChangeDetectAsString()).add("SlowPal", (Object)this.slowPalAsString()).add("Softness", (Object)this.softness()).add("SpatialAdaptiveQuantization", (Object)this.spatialAdaptiveQuantizationAsString()).add("Syntax", (Object)this.syntaxAsString()).add("Telecine", (Object)this.telecineAsString()).add("TemporalAdaptiveQuantization", (Object)this.temporalAdaptiveQuantizationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "CodecLevel": {
                return Optional.ofNullable(clazz.cast(this.codecLevelAsString()));
            }
            case "CodecProfile": {
                return Optional.ofNullable(clazz.cast(this.codecProfileAsString()));
            }
            case "DynamicSubGop": {
                return Optional.ofNullable(clazz.cast(this.dynamicSubGopAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopClosedCadence": {
                return Optional.ofNullable(clazz.cast(this.gopClosedCadence()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.ofNullable(clazz.cast(this.gopSizeUnitsAsString()));
            }
            case "HrdBufferFinalFillPercentage": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferFinalFillPercentage()));
            }
            case "HrdBufferInitialFillPercentage": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferInitialFillPercentage()));
            }
            case "HrdBufferSize": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferSize()));
            }
            case "InterlaceMode": {
                return Optional.ofNullable(clazz.cast(this.interlaceModeAsString()));
            }
            case "IntraDcPrecision": {
                return Optional.ofNullable(clazz.cast(this.intraDcPrecisionAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MinIInterval": {
                return Optional.ofNullable(clazz.cast(this.minIInterval()));
            }
            case "NumberBFramesBetweenReferenceFrames": {
                return Optional.ofNullable(clazz.cast(this.numberBFramesBetweenReferenceFrames()));
            }
            case "ParControl": {
                return Optional.ofNullable(clazz.cast(this.parControlAsString()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "PerFrameMetrics": {
                return Optional.ofNullable(clazz.cast(this.perFrameMetricsAsStrings()));
            }
            case "QualityTuningLevel": {
                return Optional.ofNullable(clazz.cast(this.qualityTuningLevelAsString()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "ScanTypeConversionMode": {
                return Optional.ofNullable(clazz.cast(this.scanTypeConversionModeAsString()));
            }
            case "SceneChangeDetect": {
                return Optional.ofNullable(clazz.cast(this.sceneChangeDetectAsString()));
            }
            case "SlowPal": {
                return Optional.ofNullable(clazz.cast(this.slowPalAsString()));
            }
            case "Softness": {
                return Optional.ofNullable(clazz.cast(this.softness()));
            }
            case "SpatialAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.spatialAdaptiveQuantizationAsString()));
            }
            case "Syntax": {
                return Optional.ofNullable(clazz.cast(this.syntaxAsString()));
            }
            case "Telecine": {
                return Optional.ofNullable(clazz.cast(this.telecineAsString()));
            }
            case "TemporalAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.temporalAdaptiveQuantizationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("adaptiveQuantization", ADAPTIVE_QUANTIZATION_FIELD);
        map.put("bitrate", BITRATE_FIELD);
        map.put("codecLevel", CODEC_LEVEL_FIELD);
        map.put("codecProfile", CODEC_PROFILE_FIELD);
        map.put("dynamicSubGop", DYNAMIC_SUB_GOP_FIELD);
        map.put("framerateControl", FRAMERATE_CONTROL_FIELD);
        map.put("framerateConversionAlgorithm", FRAMERATE_CONVERSION_ALGORITHM_FIELD);
        map.put("framerateDenominator", FRAMERATE_DENOMINATOR_FIELD);
        map.put("framerateNumerator", FRAMERATE_NUMERATOR_FIELD);
        map.put("gopClosedCadence", GOP_CLOSED_CADENCE_FIELD);
        map.put("gopSize", GOP_SIZE_FIELD);
        map.put("gopSizeUnits", GOP_SIZE_UNITS_FIELD);
        map.put("hrdBufferFinalFillPercentage", HRD_BUFFER_FINAL_FILL_PERCENTAGE_FIELD);
        map.put("hrdBufferInitialFillPercentage", HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD);
        map.put("hrdBufferSize", HRD_BUFFER_SIZE_FIELD);
        map.put("interlaceMode", INTERLACE_MODE_FIELD);
        map.put("intraDcPrecision", INTRA_DC_PRECISION_FIELD);
        map.put("maxBitrate", MAX_BITRATE_FIELD);
        map.put("minIInterval", MIN_I_INTERVAL_FIELD);
        map.put("numberBFramesBetweenReferenceFrames", NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD);
        map.put("parControl", PAR_CONTROL_FIELD);
        map.put("parDenominator", PAR_DENOMINATOR_FIELD);
        map.put("parNumerator", PAR_NUMERATOR_FIELD);
        map.put("perFrameMetrics", PER_FRAME_METRICS_FIELD);
        map.put("qualityTuningLevel", QUALITY_TUNING_LEVEL_FIELD);
        map.put("rateControlMode", RATE_CONTROL_MODE_FIELD);
        map.put("scanTypeConversionMode", SCAN_TYPE_CONVERSION_MODE_FIELD);
        map.put("sceneChangeDetect", SCENE_CHANGE_DETECT_FIELD);
        map.put("slowPal", SLOW_PAL_FIELD);
        map.put("softness", SOFTNESS_FIELD);
        map.put("spatialAdaptiveQuantization", SPATIAL_ADAPTIVE_QUANTIZATION_FIELD);
        map.put("syntax", SYNTAX_FIELD);
        map.put("telecine", TELECINE_FIELD);
        map.put("temporalAdaptiveQuantization", TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Mpeg2Settings, T> g) {
        return obj -> g.apply((Mpeg2Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private Integer bitrate;
        private String codecLevel;
        private String codecProfile;
        private String dynamicSubGop;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private Integer gopClosedCadence;
        private Double gopSize;
        private String gopSizeUnits;
        private Integer hrdBufferFinalFillPercentage;
        private Integer hrdBufferInitialFillPercentage;
        private Integer hrdBufferSize;
        private String interlaceMode;
        private String intraDcPrecision;
        private Integer maxBitrate;
        private Integer minIInterval;
        private Integer numberBFramesBetweenReferenceFrames;
        private String parControl;
        private Integer parDenominator;
        private Integer parNumerator;
        private List<String> perFrameMetrics = DefaultSdkAutoConstructList.getInstance();
        private String qualityTuningLevel;
        private String rateControlMode;
        private String scanTypeConversionMode;
        private String sceneChangeDetect;
        private String slowPal;
        private Integer softness;
        private String spatialAdaptiveQuantization;
        private String syntax;
        private String telecine;
        private String temporalAdaptiveQuantization;

        private BuilderImpl() {
        }

        private BuilderImpl(Mpeg2Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.bitrate(model.bitrate);
            this.codecLevel(model.codecLevel);
            this.codecProfile(model.codecProfile);
            this.dynamicSubGop(model.dynamicSubGop);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopClosedCadence(model.gopClosedCadence);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.hrdBufferFinalFillPercentage(model.hrdBufferFinalFillPercentage);
            this.hrdBufferInitialFillPercentage(model.hrdBufferInitialFillPercentage);
            this.hrdBufferSize(model.hrdBufferSize);
            this.interlaceMode(model.interlaceMode);
            this.intraDcPrecision(model.intraDcPrecision);
            this.maxBitrate(model.maxBitrate);
            this.minIInterval(model.minIInterval);
            this.numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            this.parControl(model.parControl);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.perFrameMetricsWithStrings(model.perFrameMetrics);
            this.qualityTuningLevel(model.qualityTuningLevel);
            this.rateControlMode(model.rateControlMode);
            this.scanTypeConversionMode(model.scanTypeConversionMode);
            this.sceneChangeDetect(model.sceneChangeDetect);
            this.slowPal(model.slowPal);
            this.softness(model.softness);
            this.spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            this.syntax(model.syntax);
            this.telecine(model.telecine);
            this.temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(Mpeg2AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getCodecLevel() {
            return this.codecLevel;
        }

        public final void setCodecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
        }

        @Override
        public final Builder codecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
            return this;
        }

        @Override
        public final Builder codecLevel(Mpeg2CodecLevel codecLevel) {
            this.codecLevel(codecLevel == null ? null : codecLevel.toString());
            return this;
        }

        public final String getCodecProfile() {
            return this.codecProfile;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(Mpeg2CodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final String getDynamicSubGop() {
            return this.dynamicSubGop;
        }

        public final void setDynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
        }

        @Override
        public final Builder dynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
            return this;
        }

        @Override
        public final Builder dynamicSubGop(Mpeg2DynamicSubGop dynamicSubGop) {
            this.dynamicSubGop(dynamicSubGop == null ? null : dynamicSubGop.toString());
            return this;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(Mpeg2FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(Mpeg2FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(Mpeg2GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final Integer getHrdBufferFinalFillPercentage() {
            return this.hrdBufferFinalFillPercentage;
        }

        public final void setHrdBufferFinalFillPercentage(Integer hrdBufferFinalFillPercentage) {
            this.hrdBufferFinalFillPercentage = hrdBufferFinalFillPercentage;
        }

        @Override
        public final Builder hrdBufferFinalFillPercentage(Integer hrdBufferFinalFillPercentage) {
            this.hrdBufferFinalFillPercentage = hrdBufferFinalFillPercentage;
            return this;
        }

        public final Integer getHrdBufferInitialFillPercentage() {
            return this.hrdBufferInitialFillPercentage;
        }

        public final void setHrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
        }

        @Override
        public final Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
            return this;
        }

        public final Integer getHrdBufferSize() {
            return this.hrdBufferSize;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(Mpeg2InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final String getIntraDcPrecision() {
            return this.intraDcPrecision;
        }

        public final void setIntraDcPrecision(String intraDcPrecision) {
            this.intraDcPrecision = intraDcPrecision;
        }

        @Override
        public final Builder intraDcPrecision(String intraDcPrecision) {
            this.intraDcPrecision = intraDcPrecision;
            return this;
        }

        @Override
        public final Builder intraDcPrecision(Mpeg2IntraDcPrecision intraDcPrecision) {
            this.intraDcPrecision(intraDcPrecision == null ? null : intraDcPrecision.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMinIInterval() {
            return this.minIInterval;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return this.numberBFramesBetweenReferenceFrames;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final String getParControl() {
            return this.parControl;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(Mpeg2ParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final Collection<String> getPerFrameMetrics() {
            if (this.perFrameMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.perFrameMetrics;
        }

        public final void setPerFrameMetrics(Collection<String> perFrameMetrics) {
            this.perFrameMetrics = ___listOfFrameMetricTypeCopier.copy(perFrameMetrics);
        }

        @Override
        public final Builder perFrameMetricsWithStrings(Collection<String> perFrameMetrics) {
            this.perFrameMetrics = ___listOfFrameMetricTypeCopier.copy(perFrameMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder perFrameMetricsWithStrings(String ... perFrameMetrics) {
            this.perFrameMetricsWithStrings(Arrays.asList(perFrameMetrics));
            return this;
        }

        @Override
        public final Builder perFrameMetrics(Collection<FrameMetricType> perFrameMetrics) {
            this.perFrameMetrics = ___listOfFrameMetricTypeCopier.copyEnumToString(perFrameMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder perFrameMetrics(FrameMetricType ... perFrameMetrics) {
            this.perFrameMetrics(Arrays.asList(perFrameMetrics));
            return this;
        }

        public final String getQualityTuningLevel() {
            return this.qualityTuningLevel;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(Mpeg2QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(Mpeg2RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final String getScanTypeConversionMode() {
            return this.scanTypeConversionMode;
        }

        public final void setScanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
        }

        @Override
        public final Builder scanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
            return this;
        }

        @Override
        public final Builder scanTypeConversionMode(Mpeg2ScanTypeConversionMode scanTypeConversionMode) {
            this.scanTypeConversionMode(scanTypeConversionMode == null ? null : scanTypeConversionMode.toString());
            return this;
        }

        public final String getSceneChangeDetect() {
            return this.sceneChangeDetect;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(Mpeg2SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(Mpeg2SlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final Integer getSoftness() {
            return this.softness;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final String getSpatialAdaptiveQuantization() {
            return this.spatialAdaptiveQuantization;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(Mpeg2SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final String getSyntax() {
            return this.syntax;
        }

        public final void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        @Override
        public final Builder syntax(String syntax) {
            this.syntax = syntax;
            return this;
        }

        @Override
        public final Builder syntax(Mpeg2Syntax syntax) {
            this.syntax(syntax == null ? null : syntax.toString());
            return this;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(Mpeg2Telecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final String getTemporalAdaptiveQuantization() {
            return this.temporalAdaptiveQuantization;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(Mpeg2TemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization == null ? null : temporalAdaptiveQuantization.toString());
            return this;
        }

        public Mpeg2Settings build() {
            return new Mpeg2Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Mpeg2Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(Mpeg2AdaptiveQuantization var1);

        public Builder bitrate(Integer var1);

        public Builder codecLevel(String var1);

        public Builder codecLevel(Mpeg2CodecLevel var1);

        public Builder codecProfile(String var1);

        public Builder codecProfile(Mpeg2CodecProfile var1);

        public Builder dynamicSubGop(String var1);

        public Builder dynamicSubGop(Mpeg2DynamicSubGop var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(Mpeg2FramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(Mpeg2FramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(Mpeg2GopSizeUnits var1);

        public Builder hrdBufferFinalFillPercentage(Integer var1);

        public Builder hrdBufferInitialFillPercentage(Integer var1);

        public Builder hrdBufferSize(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(Mpeg2InterlaceMode var1);

        public Builder intraDcPrecision(String var1);

        public Builder intraDcPrecision(Mpeg2IntraDcPrecision var1);

        public Builder maxBitrate(Integer var1);

        public Builder minIInterval(Integer var1);

        public Builder numberBFramesBetweenReferenceFrames(Integer var1);

        public Builder parControl(String var1);

        public Builder parControl(Mpeg2ParControl var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder perFrameMetricsWithStrings(Collection<String> var1);

        public Builder perFrameMetricsWithStrings(String ... var1);

        public Builder perFrameMetrics(Collection<FrameMetricType> var1);

        public Builder perFrameMetrics(FrameMetricType ... var1);

        public Builder qualityTuningLevel(String var1);

        public Builder qualityTuningLevel(Mpeg2QualityTuningLevel var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(Mpeg2RateControlMode var1);

        public Builder scanTypeConversionMode(String var1);

        public Builder scanTypeConversionMode(Mpeg2ScanTypeConversionMode var1);

        public Builder sceneChangeDetect(String var1);

        public Builder sceneChangeDetect(Mpeg2SceneChangeDetect var1);

        public Builder slowPal(String var1);

        public Builder slowPal(Mpeg2SlowPal var1);

        public Builder softness(Integer var1);

        public Builder spatialAdaptiveQuantization(String var1);

        public Builder spatialAdaptiveQuantization(Mpeg2SpatialAdaptiveQuantization var1);

        public Builder syntax(String var1);

        public Builder syntax(Mpeg2Syntax var1);

        public Builder telecine(String var1);

        public Builder telecine(Mpeg2Telecine var1);

        public Builder temporalAdaptiveQuantization(String var1);

        public Builder temporalAdaptiveQuantization(Mpeg2TemporalAdaptiveQuantization var1);
    }
}

