/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265AdaptiveQuantization {
    OFF("OFF"),
    LOW("LOW"),
    MEDIUM("MEDIUM"),
    HIGH("HIGH"),
    HIGHER("HIGHER"),
    MAX("MAX"),
    AUTO("AUTO"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265AdaptiveQuantization> VALUE_MAP;
    private final String value;

    private H265AdaptiveQuantization(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265AdaptiveQuantization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265AdaptiveQuantization> knownValues() {
        EnumSet<H265AdaptiveQuantization> knownValues = EnumSet.allOf(H265AdaptiveQuantization.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265AdaptiveQuantization.class, H265AdaptiveQuantization::toString);
    }
}

