/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.Container;
import software.amazon.awssdk.services.mediaconvert.model.Metadata;
import software.amazon.awssdk.services.mediaconvert.model.TrackMapping;
import software.amazon.awssdk.services.mediaconvert.model.___listOfTrackMappingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProbeResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProbeResult> {
    private static final SdkField<Container> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Container").getter(ProbeResult.getter(ProbeResult::container)).setter(ProbeResult.setter(Builder::container)).constructor(Container::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()}).build();
    private static final SdkField<Metadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(ProbeResult.getter(ProbeResult::metadata)).setter(ProbeResult.setter(Builder::metadata)).constructor(Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<List<TrackMapping>> TRACK_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrackMappings").getter(ProbeResult.getter(ProbeResult::trackMappings)).setter(ProbeResult.setter(Builder::trackMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrackMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FIELD, METADATA_FIELD, TRACK_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProbeResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Container container;
    private final Metadata metadata;
    private final List<TrackMapping> trackMappings;

    private ProbeResult(BuilderImpl builder) {
        this.container = builder.container;
        this.metadata = builder.metadata;
        this.trackMappings = builder.trackMappings;
    }

    public final Container container() {
        return this.container;
    }

    public final Metadata metadata() {
        return this.metadata;
    }

    public final boolean hasTrackMappings() {
        return this.trackMappings != null && !(this.trackMappings instanceof SdkAutoConstructList);
    }

    public final List<TrackMapping> trackMappings() {
        return this.trackMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrackMappings() ? this.trackMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProbeResult)) {
            return false;
        }
        ProbeResult other = (ProbeResult)obj;
        return Objects.equals(this.container(), other.container()) && Objects.equals(this.metadata(), other.metadata()) && this.hasTrackMappings() == other.hasTrackMappings() && Objects.equals(this.trackMappings(), other.trackMappings());
    }

    public final String toString() {
        return ToString.builder((String)"ProbeResult").add("Container", (Object)this.container()).add("Metadata", (Object)this.metadata()).add("TrackMappings", this.hasTrackMappings() ? this.trackMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "TrackMappings": {
                return Optional.ofNullable(clazz.cast(this.trackMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("container", CONTAINER_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("trackMappings", TRACK_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProbeResult, T> g) {
        return obj -> g.apply((ProbeResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Container container;
        private Metadata metadata;
        private List<TrackMapping> trackMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProbeResult model) {
            this.container(model.container);
            this.metadata(model.metadata);
            this.trackMappings(model.trackMappings);
        }

        public final Container.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        public final void setContainer(Container.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(Container container) {
            this.container = container;
            return this;
        }

        public final Metadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(Metadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final List<TrackMapping.Builder> getTrackMappings() {
            List<TrackMapping.Builder> result = ___listOfTrackMappingCopier.copyToBuilder(this.trackMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrackMappings(Collection<TrackMapping.BuilderImpl> trackMappings) {
            this.trackMappings = ___listOfTrackMappingCopier.copyFromBuilder(trackMappings);
        }

        @Override
        public final Builder trackMappings(Collection<TrackMapping> trackMappings) {
            this.trackMappings = ___listOfTrackMappingCopier.copy(trackMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trackMappings(TrackMapping ... trackMappings) {
            this.trackMappings(Arrays.asList(trackMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trackMappings(Consumer<TrackMapping.Builder> ... trackMappings) {
            this.trackMappings(Stream.of(trackMappings).map(c -> (TrackMapping)((TrackMapping.Builder)TrackMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProbeResult build() {
            return new ProbeResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProbeResult> {
        public Builder container(Container var1);

        default public Builder container(Consumer<Container.Builder> container) {
            return this.container((Container)((Container.Builder)Container.builder().applyMutation(container)).build());
        }

        public Builder metadata(Metadata var1);

        default public Builder metadata(Consumer<Metadata.Builder> metadata) {
            return this.metadata((Metadata)((Metadata.Builder)Metadata.builder().applyMutation(metadata)).build());
        }

        public Builder trackMappings(Collection<TrackMapping> var1);

        public Builder trackMappings(TrackMapping ... var1);

        public Builder trackMappings(Consumer<TrackMapping.Builder> ... var1);
    }
}

