/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StaticKeyProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StaticKeyProvider> {
    private static final SdkField<String> KEY_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyFormat").getter(StaticKeyProvider.getter(StaticKeyProvider::keyFormat)).setter(StaticKeyProvider.setter(Builder::keyFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyFormat").build()}).build();
    private static final SdkField<String> KEY_FORMAT_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyFormatVersions").getter(StaticKeyProvider.getter(StaticKeyProvider::keyFormatVersions)).setter(StaticKeyProvider.setter(Builder::keyFormatVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyFormatVersions").build()}).build();
    private static final SdkField<String> STATIC_KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StaticKeyValue").getter(StaticKeyProvider.getter(StaticKeyProvider::staticKeyValue)).setter(StaticKeyProvider.setter(Builder::staticKeyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticKeyValue").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(StaticKeyProvider.getter(StaticKeyProvider::url)).setter(StaticKeyProvider.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FORMAT_FIELD, KEY_FORMAT_VERSIONS_FIELD, STATIC_KEY_VALUE_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StaticKeyProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyFormat;
    private final String keyFormatVersions;
    private final String staticKeyValue;
    private final String url;

    private StaticKeyProvider(BuilderImpl builder) {
        this.keyFormat = builder.keyFormat;
        this.keyFormatVersions = builder.keyFormatVersions;
        this.staticKeyValue = builder.staticKeyValue;
        this.url = builder.url;
    }

    public final String keyFormat() {
        return this.keyFormat;
    }

    public final String keyFormatVersions() {
        return this.keyFormatVersions;
    }

    public final String staticKeyValue() {
        return this.staticKeyValue;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyFormatVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.staticKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticKeyProvider)) {
            return false;
        }
        StaticKeyProvider other = (StaticKeyProvider)obj;
        return Objects.equals(this.keyFormat(), other.keyFormat()) && Objects.equals(this.keyFormatVersions(), other.keyFormatVersions()) && Objects.equals(this.staticKeyValue(), other.staticKeyValue()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"StaticKeyProvider").add("KeyFormat", (Object)this.keyFormat()).add("KeyFormatVersions", (Object)this.keyFormatVersions()).add("StaticKeyValue", (Object)this.staticKeyValue()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyFormat": {
                return Optional.ofNullable(clazz.cast(this.keyFormat()));
            }
            case "KeyFormatVersions": {
                return Optional.ofNullable(clazz.cast(this.keyFormatVersions()));
            }
            case "StaticKeyValue": {
                return Optional.ofNullable(clazz.cast(this.staticKeyValue()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("keyFormat", KEY_FORMAT_FIELD);
        map.put("keyFormatVersions", KEY_FORMAT_VERSIONS_FIELD);
        map.put("staticKeyValue", STATIC_KEY_VALUE_FIELD);
        map.put("url", URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StaticKeyProvider, T> g) {
        return obj -> g.apply((StaticKeyProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyFormat;
        private String keyFormatVersions;
        private String staticKeyValue;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticKeyProvider model) {
            this.keyFormat(model.keyFormat);
            this.keyFormatVersions(model.keyFormatVersions);
            this.staticKeyValue(model.staticKeyValue);
            this.url(model.url);
        }

        public final String getKeyFormat() {
            return this.keyFormat;
        }

        public final void setKeyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        @Override
        public final Builder keyFormat(String keyFormat) {
            this.keyFormat = keyFormat;
            return this;
        }

        public final String getKeyFormatVersions() {
            return this.keyFormatVersions;
        }

        public final void setKeyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
        }

        @Override
        public final Builder keyFormatVersions(String keyFormatVersions) {
            this.keyFormatVersions = keyFormatVersions;
            return this;
        }

        public final String getStaticKeyValue() {
            return this.staticKeyValue;
        }

        public final void setStaticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
        }

        @Override
        public final Builder staticKeyValue(String staticKeyValue) {
            this.staticKeyValue = staticKeyValue;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public StaticKeyProvider build() {
            return new StaticKeyProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StaticKeyProvider> {
        public Builder keyFormat(String var1);

        public Builder keyFormatVersions(String var1);

        public Builder staticKeyValue(String var1);

        public Builder url(String var1);
    }
}

