/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum XavcFramerateConversionAlgorithm {
    DUPLICATE_DROP("DUPLICATE_DROP"),
    INTERPOLATE("INTERPOLATE"),
    FRAMEFORMER("FRAMEFORMER"),
    MAINTAIN_FRAME_COUNT("MAINTAIN_FRAME_COUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, XavcFramerateConversionAlgorithm> VALUE_MAP;
    private final String value;

    private XavcFramerateConversionAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static XavcFramerateConversionAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<XavcFramerateConversionAlgorithm> knownValues() {
        EnumSet<XavcFramerateConversionAlgorithm> knownValues = EnumSet.allOf(XavcFramerateConversionAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(XavcFramerateConversionAlgorithm.class, XavcFramerateConversionAlgorithm::toString);
    }
}

