/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.Output;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.___listOfOutputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputGroup> {
    private static final SdkField<String> CUSTOM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OutputGroup.getter(OutputGroup::customName)).setter(OutputGroup.setter(Builder::customName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OutputGroup.getter(OutputGroup::name)).setter(OutputGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<OutputGroupSettings> OUTPUT_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OutputGroup.getter(OutputGroup::outputGroupSettings)).setter(OutputGroup.setter(Builder::outputGroupSettings)).constructor(OutputGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroupSettings").build()}).build();
    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OutputGroup.getter(OutputGroup::outputs)).setter(OutputGroup.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_NAME_FIELD, NAME_FIELD, OUTPUT_GROUP_SETTINGS_FIELD, OUTPUTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String customName;
    private final String name;
    private final OutputGroupSettings outputGroupSettings;
    private final List<Output> outputs;

    private OutputGroup(BuilderImpl builder) {
        this.customName = builder.customName;
        this.name = builder.name;
        this.outputGroupSettings = builder.outputGroupSettings;
        this.outputs = builder.outputs;
    }

    public String customName() {
        return this.customName;
    }

    public String name() {
        return this.name;
    }

    public OutputGroupSettings outputGroupSettings() {
        return this.outputGroupSettings;
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroup)) {
            return false;
        }
        OutputGroup other = (OutputGroup)obj;
        return Objects.equals(this.customName(), other.customName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.outputGroupSettings(), other.outputGroupSettings()) && Objects.equals(this.outputs(), other.outputs());
    }

    public String toString() {
        return ToString.builder((String)"OutputGroup").add("CustomName", (Object)this.customName()).add("Name", (Object)this.name()).add("OutputGroupSettings", (Object)this.outputGroupSettings()).add("Outputs", this.outputs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomName": {
                return Optional.ofNullable(clazz.cast(this.customName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OutputGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.outputGroupSettings()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputGroup, T> g) {
        return obj -> g.apply((OutputGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customName;
        private String name;
        private OutputGroupSettings outputGroupSettings;
        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroup model) {
            this.customName(model.customName);
            this.name(model.name);
            this.outputGroupSettings(model.outputGroupSettings);
            this.outputs(model.outputs);
        }

        public final String getCustomName() {
            return this.customName;
        }

        @Override
        public final Builder customName(String customName) {
            this.customName = customName;
            return this;
        }

        public final void setCustomName(String customName) {
            this.customName = customName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final OutputGroupSettings.Builder getOutputGroupSettings() {
            return this.outputGroupSettings != null ? this.outputGroupSettings.toBuilder() : null;
        }

        @Override
        public final Builder outputGroupSettings(OutputGroupSettings outputGroupSettings) {
            this.outputGroupSettings = outputGroupSettings;
            return this;
        }

        public final void setOutputGroupSettings(OutputGroupSettings.BuilderImpl outputGroupSettings) {
            this.outputGroupSettings = outputGroupSettings != null ? outputGroupSettings.build() : null;
        }

        public final Collection<Output.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = ___listOfOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = ___listOfOutputCopier.copyFromBuilder(outputs);
        }

        public OutputGroup build() {
            return new OutputGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputGroup> {
        public Builder customName(String var1);

        public Builder name(String var1);

        public Builder outputGroupSettings(OutputGroupSettings var1);

        default public Builder outputGroupSettings(Consumer<OutputGroupSettings.Builder> outputGroupSettings) {
            return this.outputGroupSettings((OutputGroupSettings)((OutputGroupSettings.Builder)OutputGroupSettings.builder().applyMutation(outputGroupSettings)).build());
        }

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);
    }
}

