/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Mpeg2CodecLevel {
    AUTO("AUTO"),
    LOW("LOW"),
    MAIN("MAIN"),
    HIGH1440("HIGH1440"),
    HIGH("HIGH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Mpeg2CodecLevel> VALUE_MAP;
    private final String value;

    private Mpeg2CodecLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Mpeg2CodecLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Mpeg2CodecLevel> knownValues() {
        EnumSet<Mpeg2CodecLevel> knownValues = EnumSet.allOf(Mpeg2CodecLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Mpeg2CodecLevel.class, Mpeg2CodecLevel::toString);
    }
}

