/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlacSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlacSettings> {
    private static final SdkField<Integer> BIT_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BitDepth").getter(FlacSettings.getter(FlacSettings::bitDepth)).setter(FlacSettings.setter(Builder::bitDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitDepth").build()}).build();
    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Channels").getter(FlacSettings.getter(FlacSettings::channels)).setter(FlacSettings.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()}).build();
    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampleRate").getter(FlacSettings.getter(FlacSettings::sampleRate)).setter(FlacSettings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIT_DEPTH_FIELD, CHANNELS_FIELD, SAMPLE_RATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlacSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer bitDepth;
    private final Integer channels;
    private final Integer sampleRate;

    private FlacSettings(BuilderImpl builder) {
        this.bitDepth = builder.bitDepth;
        this.channels = builder.channels;
        this.sampleRate = builder.sampleRate;
    }

    public final Integer bitDepth() {
        return this.bitDepth;
    }

    public final Integer channels() {
        return this.channels;
    }

    public final Integer sampleRate() {
        return this.sampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlacSettings)) {
            return false;
        }
        FlacSettings other = (FlacSettings)obj;
        return Objects.equals(this.bitDepth(), other.bitDepth()) && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.sampleRate(), other.sampleRate());
    }

    public final String toString() {
        return ToString.builder((String)"FlacSettings").add("BitDepth", (Object)this.bitDepth()).add("Channels", (Object)this.channels()).add("SampleRate", (Object)this.sampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BitDepth": {
                return Optional.ofNullable(clazz.cast(this.bitDepth()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("bitDepth", BIT_DEPTH_FIELD);
        map.put("channels", CHANNELS_FIELD);
        map.put("sampleRate", SAMPLE_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlacSettings, T> g) {
        return obj -> g.apply((FlacSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitDepth;
        private Integer channels;
        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(FlacSettings model) {
            this.bitDepth(model.bitDepth);
            this.channels(model.channels);
            this.sampleRate(model.sampleRate);
        }

        public final Integer getBitDepth() {
            return this.bitDepth;
        }

        public final void setBitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
        }

        @Override
        public final Builder bitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final Integer getChannels() {
            return this.channels;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public FlacSettings build() {
            return new FlacSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlacSettings> {
        public Builder bitDepth(Integer var1);

        public Builder channels(Integer var1);

        public Builder sampleRate(Integer var1);
    }
}

