/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.AudioChannelTag;
import software.amazon.awssdk.services.mediaconvert.model.___listOfAudioChannelTagCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioChannelTaggingSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioChannelTaggingSettings> {
    private static final SdkField<String> CHANNEL_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelTag").getter(AudioChannelTaggingSettings.getter(AudioChannelTaggingSettings::channelTagAsString)).setter(AudioChannelTaggingSettings.setter(Builder::channelTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelTag").build()}).build();
    private static final SdkField<List<String>> CHANNEL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelTags").getter(AudioChannelTaggingSettings.getter(AudioChannelTaggingSettings::channelTagsAsStrings)).setter(AudioChannelTaggingSettings.setter(Builder::channelTagsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_TAG_FIELD, CHANNEL_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("channelTag", CHANNEL_TAG_FIELD);
            this.put("channelTags", CHANNEL_TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String channelTag;
    private final List<String> channelTags;

    private AudioChannelTaggingSettings(BuilderImpl builder) {
        this.channelTag = builder.channelTag;
        this.channelTags = builder.channelTags;
    }

    public final AudioChannelTag channelTag() {
        return AudioChannelTag.fromValue(this.channelTag);
    }

    public final String channelTagAsString() {
        return this.channelTag;
    }

    public final List<AudioChannelTag> channelTags() {
        return ___listOfAudioChannelTagCopier.copyStringToEnum(this.channelTags);
    }

    public final boolean hasChannelTags() {
        return this.channelTags != null && !(this.channelTags instanceof SdkAutoConstructList);
    }

    public final List<String> channelTagsAsStrings() {
        return this.channelTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelTagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelTags() ? this.channelTagsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioChannelTaggingSettings)) {
            return false;
        }
        AudioChannelTaggingSettings other = (AudioChannelTaggingSettings)obj;
        return Objects.equals(this.channelTagAsString(), other.channelTagAsString()) && this.hasChannelTags() == other.hasChannelTags() && Objects.equals(this.channelTagsAsStrings(), other.channelTagsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AudioChannelTaggingSettings").add("ChannelTag", (Object)this.channelTagAsString()).add("ChannelTags", this.hasChannelTags() ? this.channelTagsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelTag": {
                return Optional.ofNullable(clazz.cast(this.channelTagAsString()));
            }
            case "ChannelTags": {
                return Optional.ofNullable(clazz.cast(this.channelTagsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AudioChannelTaggingSettings, T> g) {
        return obj -> g.apply((AudioChannelTaggingSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelTag;
        private List<String> channelTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioChannelTaggingSettings model) {
            this.channelTag(model.channelTag);
            this.channelTagsWithStrings(model.channelTags);
        }

        public final String getChannelTag() {
            return this.channelTag;
        }

        public final void setChannelTag(String channelTag) {
            this.channelTag = channelTag;
        }

        @Override
        public final Builder channelTag(String channelTag) {
            this.channelTag = channelTag;
            return this;
        }

        @Override
        public final Builder channelTag(AudioChannelTag channelTag) {
            this.channelTag(channelTag == null ? null : channelTag.toString());
            return this;
        }

        public final Collection<String> getChannelTags() {
            if (this.channelTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channelTags;
        }

        public final void setChannelTags(Collection<String> channelTags) {
            this.channelTags = ___listOfAudioChannelTagCopier.copy(channelTags);
        }

        @Override
        public final Builder channelTagsWithStrings(Collection<String> channelTags) {
            this.channelTags = ___listOfAudioChannelTagCopier.copy(channelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelTagsWithStrings(String ... channelTags) {
            this.channelTagsWithStrings(Arrays.asList(channelTags));
            return this;
        }

        @Override
        public final Builder channelTags(Collection<AudioChannelTag> channelTags) {
            this.channelTags = ___listOfAudioChannelTagCopier.copyEnumToString(channelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelTags(AudioChannelTag ... channelTags) {
            this.channelTags(Arrays.asList(channelTags));
            return this;
        }

        public AudioChannelTaggingSettings build() {
            return new AudioChannelTaggingSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioChannelTaggingSettings> {
        public Builder channelTag(String var1);

        public Builder channelTag(AudioChannelTag var1);

        public Builder channelTagsWithStrings(Collection<String> var1);

        public Builder channelTagsWithStrings(String ... var1);

        public Builder channelTags(Collection<AudioChannelTag> var1);

        public Builder channelTags(AudioChannelTag ... var1);
    }
}

