/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ColorSpace {
    FOLLOW("FOLLOW"),
    REC_601("REC_601"),
    REC_709("REC_709"),
    HDR10("HDR10"),
    HLG_2020("HLG_2020"),
    P3_DCI("P3DCI"),
    P3_D65_SDR("P3D65_SDR"),
    P3_D65_HDR("P3D65_HDR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ColorSpace> VALUE_MAP;
    private final String value;

    private ColorSpace(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ColorSpace fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ColorSpace> knownValues() {
        EnumSet<ColorSpace> knownValues = EnumSet.allOf(ColorSpace.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ColorSpace.class, ColorSpace::toString);
    }
}

