/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoPlaybackDeviceCompatibility;
import software.amazon.awssdk.services.mediaconvert.model.SpekeKeyProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashIsoEncryptionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashIsoEncryptionSettings> {
    private static final SdkField<String> PLAYBACK_DEVICE_COMPATIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackDeviceCompatibility").getter(DashIsoEncryptionSettings.getter(DashIsoEncryptionSettings::playbackDeviceCompatibilityAsString)).setter(DashIsoEncryptionSettings.setter(Builder::playbackDeviceCompatibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackDeviceCompatibility").build()}).build();
    private static final SdkField<SpekeKeyProvider> SPEKE_KEY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpekeKeyProvider").getter(DashIsoEncryptionSettings.getter(DashIsoEncryptionSettings::spekeKeyProvider)).setter(DashIsoEncryptionSettings.setter(Builder::spekeKeyProvider)).constructor(SpekeKeyProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeKeyProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAYBACK_DEVICE_COMPATIBILITY_FIELD, SPEKE_KEY_PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("playbackDeviceCompatibility", PLAYBACK_DEVICE_COMPATIBILITY_FIELD);
            this.put("spekeKeyProvider", SPEKE_KEY_PROVIDER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String playbackDeviceCompatibility;
    private final SpekeKeyProvider spekeKeyProvider;

    private DashIsoEncryptionSettings(BuilderImpl builder) {
        this.playbackDeviceCompatibility = builder.playbackDeviceCompatibility;
        this.spekeKeyProvider = builder.spekeKeyProvider;
    }

    public final DashIsoPlaybackDeviceCompatibility playbackDeviceCompatibility() {
        return DashIsoPlaybackDeviceCompatibility.fromValue(this.playbackDeviceCompatibility);
    }

    public final String playbackDeviceCompatibilityAsString() {
        return this.playbackDeviceCompatibility;
    }

    public final SpekeKeyProvider spekeKeyProvider() {
        return this.spekeKeyProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackDeviceCompatibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spekeKeyProvider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashIsoEncryptionSettings)) {
            return false;
        }
        DashIsoEncryptionSettings other = (DashIsoEncryptionSettings)obj;
        return Objects.equals(this.playbackDeviceCompatibilityAsString(), other.playbackDeviceCompatibilityAsString()) && Objects.equals(this.spekeKeyProvider(), other.spekeKeyProvider());
    }

    public final String toString() {
        return ToString.builder((String)"DashIsoEncryptionSettings").add("PlaybackDeviceCompatibility", (Object)this.playbackDeviceCompatibilityAsString()).add("SpekeKeyProvider", (Object)this.spekeKeyProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlaybackDeviceCompatibility": {
                return Optional.ofNullable(clazz.cast(this.playbackDeviceCompatibilityAsString()));
            }
            case "SpekeKeyProvider": {
                return Optional.ofNullable(clazz.cast(this.spekeKeyProvider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DashIsoEncryptionSettings, T> g) {
        return obj -> g.apply((DashIsoEncryptionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String playbackDeviceCompatibility;
        private SpekeKeyProvider spekeKeyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(DashIsoEncryptionSettings model) {
            this.playbackDeviceCompatibility(model.playbackDeviceCompatibility);
            this.spekeKeyProvider(model.spekeKeyProvider);
        }

        public final String getPlaybackDeviceCompatibility() {
            return this.playbackDeviceCompatibility;
        }

        public final void setPlaybackDeviceCompatibility(String playbackDeviceCompatibility) {
            this.playbackDeviceCompatibility = playbackDeviceCompatibility;
        }

        @Override
        public final Builder playbackDeviceCompatibility(String playbackDeviceCompatibility) {
            this.playbackDeviceCompatibility = playbackDeviceCompatibility;
            return this;
        }

        @Override
        public final Builder playbackDeviceCompatibility(DashIsoPlaybackDeviceCompatibility playbackDeviceCompatibility) {
            this.playbackDeviceCompatibility(playbackDeviceCompatibility == null ? null : playbackDeviceCompatibility.toString());
            return this;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return this.spekeKeyProvider != null ? this.spekeKeyProvider.toBuilder() : null;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public DashIsoEncryptionSettings build() {
            return new DashIsoEncryptionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashIsoEncryptionSettings> {
        public Builder playbackDeviceCompatibility(String var1);

        public Builder playbackDeviceCompatibility(DashIsoPlaybackDeviceCompatibility var1);

        public Builder spekeKeyProvider(SpekeKeyProvider var1);

        default public Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return this.spekeKeyProvider((SpekeKeyProvider)((SpekeKeyProvider.Builder)SpekeKeyProvider.builder().applyMutation(spekeKeyProvider)).build());
        }
    }
}

