/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsRenditionGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsRenditionGroupSettings> {
    private static final SdkField<String> RENDITION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenditionGroupId").getter(HlsRenditionGroupSettings.getter(HlsRenditionGroupSettings::renditionGroupId)).setter(HlsRenditionGroupSettings.setter(Builder::renditionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionGroupId").build()}).build();
    private static final SdkField<String> RENDITION_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenditionLanguageCode").getter(HlsRenditionGroupSettings.getter(HlsRenditionGroupSettings::renditionLanguageCodeAsString)).setter(HlsRenditionGroupSettings.setter(Builder::renditionLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionLanguageCode").build()}).build();
    private static final SdkField<String> RENDITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenditionName").getter(HlsRenditionGroupSettings.getter(HlsRenditionGroupSettings::renditionName)).setter(HlsRenditionGroupSettings.setter(Builder::renditionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENDITION_GROUP_ID_FIELD, RENDITION_LANGUAGE_CODE_FIELD, RENDITION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("renditionGroupId", RENDITION_GROUP_ID_FIELD);
            this.put("renditionLanguageCode", RENDITION_LANGUAGE_CODE_FIELD);
            this.put("renditionName", RENDITION_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String renditionGroupId;
    private final String renditionLanguageCode;
    private final String renditionName;

    private HlsRenditionGroupSettings(BuilderImpl builder) {
        this.renditionGroupId = builder.renditionGroupId;
        this.renditionLanguageCode = builder.renditionLanguageCode;
        this.renditionName = builder.renditionName;
    }

    public final String renditionGroupId() {
        return this.renditionGroupId;
    }

    public final LanguageCode renditionLanguageCode() {
        return LanguageCode.fromValue(this.renditionLanguageCode);
    }

    public final String renditionLanguageCodeAsString() {
        return this.renditionLanguageCode;
    }

    public final String renditionName() {
        return this.renditionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.renditionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.renditionLanguageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.renditionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsRenditionGroupSettings)) {
            return false;
        }
        HlsRenditionGroupSettings other = (HlsRenditionGroupSettings)obj;
        return Objects.equals(this.renditionGroupId(), other.renditionGroupId()) && Objects.equals(this.renditionLanguageCodeAsString(), other.renditionLanguageCodeAsString()) && Objects.equals(this.renditionName(), other.renditionName());
    }

    public final String toString() {
        return ToString.builder((String)"HlsRenditionGroupSettings").add("RenditionGroupId", (Object)this.renditionGroupId()).add("RenditionLanguageCode", (Object)this.renditionLanguageCodeAsString()).add("RenditionName", (Object)this.renditionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RenditionGroupId": {
                return Optional.ofNullable(clazz.cast(this.renditionGroupId()));
            }
            case "RenditionLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.renditionLanguageCodeAsString()));
            }
            case "RenditionName": {
                return Optional.ofNullable(clazz.cast(this.renditionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HlsRenditionGroupSettings, T> g) {
        return obj -> g.apply((HlsRenditionGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String renditionGroupId;
        private String renditionLanguageCode;
        private String renditionName;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsRenditionGroupSettings model) {
            this.renditionGroupId(model.renditionGroupId);
            this.renditionLanguageCode(model.renditionLanguageCode);
            this.renditionName(model.renditionName);
        }

        public final String getRenditionGroupId() {
            return this.renditionGroupId;
        }

        public final void setRenditionGroupId(String renditionGroupId) {
            this.renditionGroupId = renditionGroupId;
        }

        @Override
        public final Builder renditionGroupId(String renditionGroupId) {
            this.renditionGroupId = renditionGroupId;
            return this;
        }

        public final String getRenditionLanguageCode() {
            return this.renditionLanguageCode;
        }

        public final void setRenditionLanguageCode(String renditionLanguageCode) {
            this.renditionLanguageCode = renditionLanguageCode;
        }

        @Override
        public final Builder renditionLanguageCode(String renditionLanguageCode) {
            this.renditionLanguageCode = renditionLanguageCode;
            return this;
        }

        @Override
        public final Builder renditionLanguageCode(LanguageCode renditionLanguageCode) {
            this.renditionLanguageCode(renditionLanguageCode == null ? null : renditionLanguageCode.toString());
            return this;
        }

        public final String getRenditionName() {
            return this.renditionName;
        }

        public final void setRenditionName(String renditionName) {
            this.renditionName = renditionName;
        }

        @Override
        public final Builder renditionName(String renditionName) {
            this.renditionName = renditionName;
            return this;
        }

        public HlsRenditionGroupSettings build() {
            return new HlsRenditionGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsRenditionGroupSettings> {
        public Builder renditionGroupId(String var1);

        public Builder renditionLanguageCode(String var1);

        public Builder renditionLanguageCode(LanguageCode var1);

        public Builder renditionName(String var1);
    }
}

