/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.JobStatus;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertRequest;
import software.amazon.awssdk.services.mediaconvert.model.Order;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchJobsRequest
extends MediaConvertRequest
implements ToCopyableBuilder<Builder, SearchJobsRequest> {
    private static final SdkField<String> INPUT_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputFile").getter(SearchJobsRequest.getter(SearchJobsRequest::inputFile)).setter(SearchJobsRequest.setter(Builder::inputFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("inputFile").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchJobsRequest.getter(SearchJobsRequest::maxResults)).setter(SearchJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchJobsRequest.getter(SearchJobsRequest::nextToken)).setter(SearchJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Order").getter(SearchJobsRequest.getter(SearchJobsRequest::orderAsString)).setter(SearchJobsRequest.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("order").build()}).build();
    private static final SdkField<String> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Queue").getter(SearchJobsRequest.getter(SearchJobsRequest::queue)).setter(SearchJobsRequest.setter(Builder::queue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("queue").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SearchJobsRequest.getter(SearchJobsRequest::statusAsString)).setter(SearchJobsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_FIELD, QUEUE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inputFile", INPUT_FILE_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("order", ORDER_FIELD);
            this.put("queue", QUEUE_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private final String inputFile;
    private final Integer maxResults;
    private final String nextToken;
    private final String order;
    private final String queue;
    private final String status;

    private SearchJobsRequest(BuilderImpl builder) {
        super(builder);
        this.inputFile = builder.inputFile;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.order = builder.order;
        this.queue = builder.queue;
        this.status = builder.status;
    }

    public final String inputFile() {
        return this.inputFile;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Order order() {
        return Order.fromValue(this.order);
    }

    public final String orderAsString() {
        return this.order;
    }

    public final String queue() {
        return this.queue;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchJobsRequest)) {
            return false;
        }
        SearchJobsRequest other = (SearchJobsRequest)((Object)obj);
        return Objects.equals(this.inputFile(), other.inputFile()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.orderAsString(), other.orderAsString()) && Objects.equals(this.queue(), other.queue()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchJobsRequest").add("InputFile", (Object)this.inputFile()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Order", (Object)this.orderAsString()).add("Queue", (Object)this.queue()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputFile": {
                return Optional.ofNullable(clazz.cast(this.inputFile()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchJobsRequest, T> g) {
        return obj -> g.apply((SearchJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConvertRequest.BuilderImpl
    implements Builder {
        private String inputFile;
        private Integer maxResults;
        private String nextToken;
        private String order;
        private String queue;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchJobsRequest model) {
            super(model);
            this.inputFile(model.inputFile);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.order(model.order);
            this.queue(model.queue);
            this.status(model.status);
        }

        public final String getInputFile() {
            return this.inputFile;
        }

        public final void setInputFile(String inputFile) {
            this.inputFile = inputFile;
        }

        @Override
        public final Builder inputFile(String inputFile) {
            this.inputFile = inputFile;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrder() {
            return this.order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(Order order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public final String getQueue() {
            return this.queue;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchJobsRequest build() {
            return new SearchJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConvertRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchJobsRequest> {
        public Builder inputFile(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder order(String var1);

        public Builder order(Order var1);

        public Builder queue(String var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

