/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconvert.MediaConvertClient;
import software.amazon.awssdk.services.mediaconvert.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconvert.model.JobEngineVersion;
import software.amazon.awssdk.services.mediaconvert.model.ListVersionsRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListVersionsResponse;

public class ListVersionsIterable
implements SdkIterable<ListVersionsResponse> {
    private final MediaConvertClient client;
    private final ListVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVersionsIterable(MediaConvertClient client, ListVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVersionsResponseFetcher();
    }

    public Iterator<ListVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobEngineVersion> versions() {
        Function<ListVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.versions() != null) {
                return response.versions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVersionsResponseFetcher
    implements SyncPageFetcher<ListVersionsResponse> {
        private ListVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVersionsResponse nextPage(ListVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListVersionsIterable.this.client.listVersions(ListVersionsIterable.this.firstRequest);
            }
            return ListVersionsIterable.this.client.listVersions((ListVersionsRequest)((Object)ListVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

