/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScalingBehavior {
    DEFAULT("DEFAULT"),
    STRETCH_TO_OUTPUT("STRETCH_TO_OUTPUT"),
    FIT("FIT"),
    FIT_NO_UPSCALE("FIT_NO_UPSCALE"),
    FILL("FILL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScalingBehavior> VALUE_MAP;
    private final String value;

    private ScalingBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalingBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalingBehavior> knownValues() {
        EnumSet<ScalingBehavior> knownValues = EnumSet.allOf(ScalingBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScalingBehavior.class, ScalingBehavior::toString);
    }
}

