/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CmafEncryptionType {
    SAMPLE_AES("SAMPLE_AES"),
    AES_CTR("AES_CTR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CmafEncryptionType> VALUE_MAP;
    private final String value;

    private CmafEncryptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CmafEncryptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CmafEncryptionType> knownValues() {
        EnumSet<CmafEncryptionType> knownValues = EnumSet.allOf(CmafEncryptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CmafEncryptionType.class, CmafEncryptionType::toString);
    }
}

