/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AacCodecProfile {
    LC("LC"),
    HEV1("HEV1"),
    HEV2("HEV2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AacCodecProfile> VALUE_MAP;
    private final String value;

    private AacCodecProfile(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AacCodecProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AacCodecProfile> knownValues() {
        EnumSet<AacCodecProfile> knownValues = EnumSet.allOf(AacCodecProfile.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AacCodecProfile.class, AacCodecProfile::toString);
    }
}

