/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HlsSegmentControl {
    SINGLE_FILE("SINGLE_FILE"),
    SEGMENTED_FILES("SEGMENTED_FILES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsSegmentControl> VALUE_MAP;
    private final String value;

    private HlsSegmentControl(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsSegmentControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsSegmentControl> knownValues() {
        EnumSet<HlsSegmentControl> knownValues = EnumSet.allOf(HlsSegmentControl.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HlsSegmentControl.class, HlsSegmentControl::toString);
    }
}

