/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AacSpecification {
    MPEG2("MPEG2"),
    MPEG4("MPEG4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AacSpecification> VALUE_MAP;
    private final String value;

    private AacSpecification(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AacSpecification fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AacSpecification> knownValues() {
        EnumSet<AacSpecification> knownValues = EnumSet.allOf(AacSpecification.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AacSpecification.class, AacSpecification::toString);
    }
}

