/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3ServerSideEncryptionType {
    SERVER_SIDE_ENCRYPTION_S3("SERVER_SIDE_ENCRYPTION_S3"),
    SERVER_SIDE_ENCRYPTION_KMS("SERVER_SIDE_ENCRYPTION_KMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3ServerSideEncryptionType> VALUE_MAP;
    private final String value;

    private S3ServerSideEncryptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3ServerSideEncryptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3ServerSideEncryptionType> knownValues() {
        EnumSet<S3ServerSideEncryptionType> knownValues = EnumSet.allOf(S3ServerSideEncryptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3ServerSideEncryptionType.class, S3ServerSideEncryptionType::toString);
    }
}

