/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediaconvert.DefaultMediaConvertBaseClientBuilder;
import software.amazon.awssdk.services.mediaconvert.DefaultMediaConvertClient;
import software.amazon.awssdk.services.mediaconvert.MediaConvertClient;
import software.amazon.awssdk.services.mediaconvert.MediaConvertClientBuilder;
import software.amazon.awssdk.services.mediaconvert.MediaConvertServiceClientConfiguration;
import software.amazon.awssdk.services.mediaconvert.endpoints.MediaConvertEndpointProvider;

@SdkInternalApi
final class DefaultMediaConvertClientBuilder
extends DefaultMediaConvertBaseClientBuilder<MediaConvertClientBuilder, MediaConvertClient>
implements MediaConvertClientBuilder {
    DefaultMediaConvertClientBuilder() {
    }

    @Override
    public DefaultMediaConvertClientBuilder endpointProvider(MediaConvertEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaConvertClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMediaConvertClientBuilder.validateClientOptions(clientConfiguration);
        MediaConvertServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaConvertClient client = new DefaultMediaConvertClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaConvertServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaConvertServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

