/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the XAVC profile for this output. For more information, see the Sony documentation at
 * https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points for
 * XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
 */
@Generated("software.amazon.awssdk:codegen")
public enum XavcProfile {
    XAVC_HD_INTRA_CBG("XAVC_HD_INTRA_CBG"),

    XAVC_4_K_INTRA_CBG("XAVC_4K_INTRA_CBG"),

    XAVC_4_K_INTRA_VBR("XAVC_4K_INTRA_VBR"),

    XAVC_HD("XAVC_HD"),

    XAVC_4_K("XAVC_4K"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, XavcProfile> VALUE_MAP = EnumUtils.uniqueIndex(XavcProfile.class, XavcProfile::toString);

    private final String value;

    private XavcProfile(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return XavcProfile corresponding to the value
     */
    public static XavcProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link XavcProfile}s
     */
    public static Set<XavcProfile> knownValues() {
        Set<XavcProfile> knownValues = EnumSet.allOf(XavcProfile.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
