/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2 (HIGH_422). These
 * profiles are specified in ITU-T H.264.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Xavc4kProfileCodecProfile {
    HIGH("HIGH"),

    HIGH_422("HIGH_422"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Xavc4kProfileCodecProfile> VALUE_MAP = EnumUtils.uniqueIndex(
            Xavc4kProfileCodecProfile.class, Xavc4kProfileCodecProfile::toString);

    private final String value;

    private Xavc4kProfileCodecProfile(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Xavc4kProfileCodecProfile corresponding to the value
     */
    public static Xavc4kProfileCodecProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Xavc4kProfileCodecProfile}s
     */
    public static Set<Xavc4kProfileCodecProfile> knownValues() {
        Set<Xavc4kProfileCodecProfile> knownValues = EnumSet.allOf(Xavc4kProfileCodecProfile.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
