/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL), the bandwidth and sharpness of your output is
 * reduced. You can optionally use Post temporal sharpening (postTemporalSharpening) to apply sharpening to the edges of
 * your output. Note that Post temporal sharpening will also make the bandwidth reduction from the Noise reducer
 * smaller. The default behavior, Auto (AUTO), allows the transcoder to determine whether to apply sharpening, depending
 * on your input type and quality. When you set Post temporal sharpening to Enabled (ENABLED), specify how much
 * sharpening is applied using Post temporal sharpening strength (postTemporalSharpeningStrength). Set Post temporal
 * sharpening to Disabled (DISABLED) to not apply sharpening.
 */
@Generated("software.amazon.awssdk:codegen")
public enum NoiseFilterPostTemporalSharpening {
    DISABLED("DISABLED"),

    ENABLED("ENABLED"),

    AUTO("AUTO"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NoiseFilterPostTemporalSharpening> VALUE_MAP = EnumUtils.uniqueIndex(
            NoiseFilterPostTemporalSharpening.class, NoiseFilterPostTemporalSharpening::toString);

    private final String value;

    private NoiseFilterPostTemporalSharpening(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return NoiseFilterPostTemporalSharpening corresponding to the value
     */
    public static NoiseFilterPostTemporalSharpening fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link NoiseFilterPostTemporalSharpening}s
     */
    public static Set<NoiseFilterPostTemporalSharpening> knownValues() {
        Set<NoiseFilterPostTemporalSharpening> knownValues = EnumSet.allOf(NoiseFilterPostTemporalSharpening.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
