/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForResourceResponse extends MediaConvertResponse implements
        ToCopyableBuilder<ListTagsForResourceResponse.Builder, ListTagsForResourceResponse> {
    private static final SdkField<ResourceTags> RESOURCE_TAGS_FIELD = SdkField.<ResourceTags> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceTags").getter(getter(ListTagsForResourceResponse::resourceTags))
            .setter(setter(Builder::resourceTags)).constructor(ResourceTags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TAGS_FIELD));

    private final ResourceTags resourceTags;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTags = builder.resourceTags;
    }

    /**
     * The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource.
     * 
     * @return The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource.
     */
    public final ResourceTags resourceTags() {
        return resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceTags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse) obj;
        return Objects.equals(resourceTags(), other.resourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagsForResourceResponse").add("ResourceTags", resourceTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourceResponse, T> g) {
        return obj -> g.apply((ListTagsForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForResourceResponse> {
        /**
         * The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource.
         * 
         * @param resourceTags
         *        The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(ResourceTags resourceTags);

        /**
         * The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource. This is a convenience
         * method that creates an instance of the {@link ResourceTags.Builder} avoiding the need to create one manually
         * via {@link ResourceTags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceTags.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceTags(ResourceTags)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on {@link ResourceTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(ResourceTags)
         */
        default Builder resourceTags(Consumer<ResourceTags.Builder> resourceTags) {
            return resourceTags(ResourceTags.builder().applyMutation(resourceTags).build());
        }
    }

    static final class BuilderImpl extends MediaConvertResponse.BuilderImpl implements Builder {
        private ResourceTags resourceTags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            super(model);
            resourceTags(model.resourceTags);
        }

        public final ResourceTags.Builder getResourceTags() {
            return resourceTags != null ? resourceTags.toBuilder() : null;
        }

        public final void setResourceTags(ResourceTags.BuilderImpl resourceTags) {
            this.resourceTags = resourceTags != null ? resourceTags.build() : null;
        }

        @Override
        public final Builder resourceTags(ResourceTags resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        @Override
        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
