/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify whether MediaConvert generates HLS manifests while your job is running or when your job is complete. To
 * generate HLS manifests while your job is running: Choose Enabled. Use if you want to play back your content as soon
 * as it's available. MediaConvert writes the parent and child manifests after the first three media segments are
 * written to your destination S3 bucket. It then writes new updated manifests after each additional segment is written.
 * The parent manifest includes the latest BANDWIDTH and AVERAGE-BANDWIDTH attributes, and child manifests include the
 * latest available media segment. When your job completes, the final child playlists include an EXT-X-ENDLIST tag. To
 * generate HLS manifests only when your job completes: Choose Disabled.
 */
@Generated("software.amazon.awssdk:codegen")
public enum HlsProgressiveWriteHlsManifest {
    ENABLED("ENABLED"),

    DISABLED("DISABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsProgressiveWriteHlsManifest> VALUE_MAP = EnumUtils.uniqueIndex(
            HlsProgressiveWriteHlsManifest.class, HlsProgressiveWriteHlsManifest::toString);

    private final String value;

    private HlsProgressiveWriteHlsManifest(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HlsProgressiveWriteHlsManifest corresponding to the value
     */
    public static HlsProgressiveWriteHlsManifest fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HlsProgressiveWriteHlsManifest}s
     */
    public static Set<HlsProgressiveWriteHlsManifest> knownValues() {
        Set<HlsProgressiveWriteHlsManifest> knownValues = EnumSet.allOf(HlsProgressiveWriteHlsManifest.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
