/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of
 * content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more
 * distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be
 * noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded
 * with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature
 * doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their
 * attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related
 * setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization
 * (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it
 * to Low. For content with a wider variety of textures, set it to High or Higher.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H265SpatialAdaptiveQuantization {
    DISABLED("DISABLED"),

    ENABLED("ENABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265SpatialAdaptiveQuantization> VALUE_MAP = EnumUtils.uniqueIndex(
            H265SpatialAdaptiveQuantization.class, H265SpatialAdaptiveQuantization::toString);

    private final String value;

    private H265SpatialAdaptiveQuantization(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H265SpatialAdaptiveQuantization corresponding to the value
     */
    public static H265SpatialAdaptiveQuantization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H265SpatialAdaptiveQuantization}s
     */
    public static Set<H265SpatialAdaptiveQuantization> knownValues() {
        Set<H265SpatialAdaptiveQuantization> knownValues = EnumSet.allOf(H265SpatialAdaptiveQuantization.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
