/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * When you set Adaptive Quantization (H265AdaptiveQuantization) to Auto (AUTO), or leave blank, MediaConvert
 * automatically applies quantization to improve the video quality of your output. Set Adaptive Quantization to Low
 * (LOW), Medium (MEDIUM), High (HIGH), Higher (HIGHER), or Max (MAX) to manually control the strength of the
 * quantization filter. When you do, you can specify a value for Spatial Adaptive Quantization
 * (H265SpatialAdaptiveQuantization), Temporal Adaptive Quantization (H265TemporalAdaptiveQuantization), and Flicker
 * Adaptive Quantization (H265FlickerAdaptiveQuantization), to further control the quantization filter. Set Adaptive
 * Quantization to Off (OFF) to apply no quantization to your output.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H265AdaptiveQuantization {
    OFF("OFF"),

    LOW("LOW"),

    MEDIUM("MEDIUM"),

    HIGH("HIGH"),

    HIGHER("HIGHER"),

    MAX("MAX"),

    AUTO("AUTO"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265AdaptiveQuantization> VALUE_MAP = EnumUtils.uniqueIndex(H265AdaptiveQuantization.class,
            H265AdaptiveQuantization::toString);

    private final String value;

    private H265AdaptiveQuantization(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H265AdaptiveQuantization corresponding to the value
     */
    public static H265AdaptiveQuantization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H265AdaptiveQuantization}s
     */
    public static Set<H265AdaptiveQuantization> knownValues() {
        Set<H265AdaptiveQuantization> knownValues = EnumSet.allOf(H265AdaptiveQuantization.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
