/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for Event Signaling And Messaging (ESAM). If you don't do ad insertion, you can ignore these settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EsamSettings implements SdkPojo, Serializable, ToCopyableBuilder<EsamSettings.Builder, EsamSettings> {
    private static final SdkField<EsamManifestConfirmConditionNotification> MANIFEST_CONFIRM_CONDITION_NOTIFICATION_FIELD = SdkField
            .<EsamManifestConfirmConditionNotification> builder(MarshallingType.SDK_POJO)
            .memberName("ManifestConfirmConditionNotification")
            .getter(getter(EsamSettings::manifestConfirmConditionNotification))
            .setter(setter(Builder::manifestConfirmConditionNotification))
            .constructor(EsamManifestConfirmConditionNotification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("manifestConfirmConditionNotification").build()).build();

    private static final SdkField<Integer> RESPONSE_SIGNAL_PREROLL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResponseSignalPreroll").getter(getter(EsamSettings::responseSignalPreroll))
            .setter(setter(Builder::responseSignalPreroll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseSignalPreroll").build())
            .build();

    private static final SdkField<EsamSignalProcessingNotification> SIGNAL_PROCESSING_NOTIFICATION_FIELD = SdkField
            .<EsamSignalProcessingNotification> builder(MarshallingType.SDK_POJO)
            .memberName("SignalProcessingNotification")
            .getter(getter(EsamSettings::signalProcessingNotification))
            .setter(setter(Builder::signalProcessingNotification))
            .constructor(EsamSignalProcessingNotification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalProcessingNotification")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MANIFEST_CONFIRM_CONDITION_NOTIFICATION_FIELD, RESPONSE_SIGNAL_PREROLL_FIELD, SIGNAL_PROCESSING_NOTIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final EsamManifestConfirmConditionNotification manifestConfirmConditionNotification;

    private final Integer responseSignalPreroll;

    private final EsamSignalProcessingNotification signalProcessingNotification;

    private EsamSettings(BuilderImpl builder) {
        this.manifestConfirmConditionNotification = builder.manifestConfirmConditionNotification;
        this.responseSignalPreroll = builder.responseSignalPreroll;
        this.signalProcessingNotification = builder.signalProcessingNotification;
    }

    /**
     * Specifies an ESAM ManifestConfirmConditionNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses
     * the manifest conditioning instructions that you provide in the setting MCC XML (mccXml).
     * 
     * @return Specifies an ESAM ManifestConfirmConditionNotification XML as per OC-SP-ESAM-API-I03-131025. The
     *         transcoder uses the manifest conditioning instructions that you provide in the setting MCC XML (mccXml).
     */
    public final EsamManifestConfirmConditionNotification manifestConfirmConditionNotification() {
        return manifestConfirmConditionNotification;
    }

    /**
     * Specifies the stream distance, in milliseconds, between the SCTE 35 messages that the transcoder places and the
     * splice points that they refer to. If the time between the start of the asset and the SCTE-35 message is less than
     * this value, then the transcoder places the SCTE-35 marker at the beginning of the stream.
     * 
     * @return Specifies the stream distance, in milliseconds, between the SCTE 35 messages that the transcoder places
     *         and the splice points that they refer to. If the time between the start of the asset and the SCTE-35
     *         message is less than this value, then the transcoder places the SCTE-35 marker at the beginning of the
     *         stream.
     */
    public final Integer responseSignalPreroll() {
        return responseSignalPreroll;
    }

    /**
     * Specifies an ESAM SignalProcessingNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses the
     * signal processing instructions that you provide in the setting SCC XML (sccXml).
     * 
     * @return Specifies an ESAM SignalProcessingNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses
     *         the signal processing instructions that you provide in the setting SCC XML (sccXml).
     */
    public final EsamSignalProcessingNotification signalProcessingNotification() {
        return signalProcessingNotification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestConfirmConditionNotification());
        hashCode = 31 * hashCode + Objects.hashCode(responseSignalPreroll());
        hashCode = 31 * hashCode + Objects.hashCode(signalProcessingNotification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EsamSettings)) {
            return false;
        }
        EsamSettings other = (EsamSettings) obj;
        return Objects.equals(manifestConfirmConditionNotification(), other.manifestConfirmConditionNotification())
                && Objects.equals(responseSignalPreroll(), other.responseSignalPreroll())
                && Objects.equals(signalProcessingNotification(), other.signalProcessingNotification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EsamSettings")
                .add("ManifestConfirmConditionNotification", manifestConfirmConditionNotification())
                .add("ResponseSignalPreroll", responseSignalPreroll())
                .add("SignalProcessingNotification", signalProcessingNotification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestConfirmConditionNotification":
            return Optional.ofNullable(clazz.cast(manifestConfirmConditionNotification()));
        case "ResponseSignalPreroll":
            return Optional.ofNullable(clazz.cast(responseSignalPreroll()));
        case "SignalProcessingNotification":
            return Optional.ofNullable(clazz.cast(signalProcessingNotification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EsamSettings, T> g) {
        return obj -> g.apply((EsamSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EsamSettings> {
        /**
         * Specifies an ESAM ManifestConfirmConditionNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder
         * uses the manifest conditioning instructions that you provide in the setting MCC XML (mccXml).
         * 
         * @param manifestConfirmConditionNotification
         *        Specifies an ESAM ManifestConfirmConditionNotification XML as per OC-SP-ESAM-API-I03-131025. The
         *        transcoder uses the manifest conditioning instructions that you provide in the setting MCC XML
         *        (mccXml).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestConfirmConditionNotification(EsamManifestConfirmConditionNotification manifestConfirmConditionNotification);

        /**
         * Specifies an ESAM ManifestConfirmConditionNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder
         * uses the manifest conditioning instructions that you provide in the setting MCC XML (mccXml). This is a
         * convenience method that creates an instance of the {@link EsamManifestConfirmConditionNotification.Builder}
         * avoiding the need to create one manually via {@link EsamManifestConfirmConditionNotification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EsamManifestConfirmConditionNotification.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #manifestConfirmConditionNotification(EsamManifestConfirmConditionNotification)}.
         * 
         * @param manifestConfirmConditionNotification
         *        a consumer that will call methods on {@link EsamManifestConfirmConditionNotification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestConfirmConditionNotification(EsamManifestConfirmConditionNotification)
         */
        default Builder manifestConfirmConditionNotification(
                Consumer<EsamManifestConfirmConditionNotification.Builder> manifestConfirmConditionNotification) {
            return manifestConfirmConditionNotification(EsamManifestConfirmConditionNotification.builder()
                    .applyMutation(manifestConfirmConditionNotification).build());
        }

        /**
         * Specifies the stream distance, in milliseconds, between the SCTE 35 messages that the transcoder places and
         * the splice points that they refer to. If the time between the start of the asset and the SCTE-35 message is
         * less than this value, then the transcoder places the SCTE-35 marker at the beginning of the stream.
         * 
         * @param responseSignalPreroll
         *        Specifies the stream distance, in milliseconds, between the SCTE 35 messages that the transcoder
         *        places and the splice points that they refer to. If the time between the start of the asset and the
         *        SCTE-35 message is less than this value, then the transcoder places the SCTE-35 marker at the
         *        beginning of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseSignalPreroll(Integer responseSignalPreroll);

        /**
         * Specifies an ESAM SignalProcessingNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses the
         * signal processing instructions that you provide in the setting SCC XML (sccXml).
         * 
         * @param signalProcessingNotification
         *        Specifies an ESAM SignalProcessingNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder
         *        uses the signal processing instructions that you provide in the setting SCC XML (sccXml).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalProcessingNotification(EsamSignalProcessingNotification signalProcessingNotification);

        /**
         * Specifies an ESAM SignalProcessingNotification XML as per OC-SP-ESAM-API-I03-131025. The transcoder uses the
         * signal processing instructions that you provide in the setting SCC XML (sccXml). This is a convenience method
         * that creates an instance of the {@link EsamSignalProcessingNotification.Builder} avoiding the need to create
         * one manually via {@link EsamSignalProcessingNotification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EsamSignalProcessingNotification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #signalProcessingNotification(EsamSignalProcessingNotification)}.
         * 
         * @param signalProcessingNotification
         *        a consumer that will call methods on {@link EsamSignalProcessingNotification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signalProcessingNotification(EsamSignalProcessingNotification)
         */
        default Builder signalProcessingNotification(
                Consumer<EsamSignalProcessingNotification.Builder> signalProcessingNotification) {
            return signalProcessingNotification(EsamSignalProcessingNotification.builder()
                    .applyMutation(signalProcessingNotification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EsamManifestConfirmConditionNotification manifestConfirmConditionNotification;

        private Integer responseSignalPreroll;

        private EsamSignalProcessingNotification signalProcessingNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(EsamSettings model) {
            manifestConfirmConditionNotification(model.manifestConfirmConditionNotification);
            responseSignalPreroll(model.responseSignalPreroll);
            signalProcessingNotification(model.signalProcessingNotification);
        }

        public final EsamManifestConfirmConditionNotification.Builder getManifestConfirmConditionNotification() {
            return manifestConfirmConditionNotification != null ? manifestConfirmConditionNotification.toBuilder() : null;
        }

        public final void setManifestConfirmConditionNotification(
                EsamManifestConfirmConditionNotification.BuilderImpl manifestConfirmConditionNotification) {
            this.manifestConfirmConditionNotification = manifestConfirmConditionNotification != null ? manifestConfirmConditionNotification
                    .build() : null;
        }

        @Override
        public final Builder manifestConfirmConditionNotification(
                EsamManifestConfirmConditionNotification manifestConfirmConditionNotification) {
            this.manifestConfirmConditionNotification = manifestConfirmConditionNotification;
            return this;
        }

        public final Integer getResponseSignalPreroll() {
            return responseSignalPreroll;
        }

        public final void setResponseSignalPreroll(Integer responseSignalPreroll) {
            this.responseSignalPreroll = responseSignalPreroll;
        }

        @Override
        public final Builder responseSignalPreroll(Integer responseSignalPreroll) {
            this.responseSignalPreroll = responseSignalPreroll;
            return this;
        }

        public final EsamSignalProcessingNotification.Builder getSignalProcessingNotification() {
            return signalProcessingNotification != null ? signalProcessingNotification.toBuilder() : null;
        }

        public final void setSignalProcessingNotification(
                EsamSignalProcessingNotification.BuilderImpl signalProcessingNotification) {
            this.signalProcessingNotification = signalProcessingNotification != null ? signalProcessingNotification.build()
                    : null;
        }

        @Override
        public final Builder signalProcessingNotification(EsamSignalProcessingNotification signalProcessingNotification) {
            this.signalProcessingNotification = signalProcessingNotification;
            return this;
        }

        @Override
        public EsamSettings build() {
            return new EsamSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
