/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to CEA/EIA-608 and CEA/EIA-708 (also called embedded or ancillary) captions. Set up embedded
 * captions in the same output as your video. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/embedded-output-captions.html. When you work directly in your JSON
 * job specification, include this object and any required children when you set destinationType to EMBEDDED,
 * EMBEDDED_PLUS_SCTE20, or SCTE20_PLUS_EMBEDDED.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmbeddedDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<EmbeddedDestinationSettings.Builder, EmbeddedDestinationSettings> {
    private static final SdkField<Integer> DESTINATION608_CHANNEL_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Destination608ChannelNumber")
            .getter(getter(EmbeddedDestinationSettings::destination608ChannelNumber))
            .setter(setter(Builder::destination608ChannelNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination608ChannelNumber")
                    .build()).build();

    private static final SdkField<Integer> DESTINATION708_SERVICE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Destination708ServiceNumber")
            .getter(getter(EmbeddedDestinationSettings::destination708ServiceNumber))
            .setter(setter(Builder::destination708ServiceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination708ServiceNumber")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION608_CHANNEL_NUMBER_FIELD, DESTINATION708_SERVICE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer destination608ChannelNumber;

    private final Integer destination708ServiceNumber;

    private EmbeddedDestinationSettings(BuilderImpl builder) {
        this.destination608ChannelNumber = builder.destination608ChannelNumber;
        this.destination708ServiceNumber = builder.destination708ServiceNumber;
    }

    /**
     * Ignore this setting unless your input captions are SCC format and your output captions are embedded in the video
     * stream. Specify a CC number for each captions channel in this output. If you have two channels, choose CC numbers
     * that aren't in the same field. For example, choose 1 and 3. For more information, see
     * https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
     * 
     * @return Ignore this setting unless your input captions are SCC format and your output captions are embedded in
     *         the video stream. Specify a CC number for each captions channel in this output. If you have two channels,
     *         choose CC numbers that aren't in the same field. For example, choose 1 and 3. For more information, see
     *         https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
     */
    public final Integer destination608ChannelNumber() {
        return destination608ChannelNumber;
    }

    /**
     * Ignore this setting unless your input captions are SCC format and you want both 608 and 708 captions embedded in
     * your output stream. Optionally, specify the 708 service number for each output captions channel. Choose a
     * different number for each channel. To use this setting, also set Force 608 to 708 upconvert (Convert608To708) to
     * Upconvert (UPCONVERT) in your input captions selector settings. If you choose to upconvert but don't specify a
     * 708 service number, MediaConvert uses the number that you specify for CC channel number
     * (destination608ChannelNumber) for the 708 service number. For more information, see
     * https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
     * 
     * @return Ignore this setting unless your input captions are SCC format and you want both 608 and 708 captions
     *         embedded in your output stream. Optionally, specify the 708 service number for each output captions
     *         channel. Choose a different number for each channel. To use this setting, also set Force 608 to 708
     *         upconvert (Convert608To708) to Upconvert (UPCONVERT) in your input captions selector settings. If you
     *         choose to upconvert but don't specify a 708 service number, MediaConvert uses the number that you specify
     *         for CC channel number (destination608ChannelNumber) for the 708 service number. For more information, see
     *         https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
     */
    public final Integer destination708ServiceNumber() {
        return destination708ServiceNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination608ChannelNumber());
        hashCode = 31 * hashCode + Objects.hashCode(destination708ServiceNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmbeddedDestinationSettings)) {
            return false;
        }
        EmbeddedDestinationSettings other = (EmbeddedDestinationSettings) obj;
        return Objects.equals(destination608ChannelNumber(), other.destination608ChannelNumber())
                && Objects.equals(destination708ServiceNumber(), other.destination708ServiceNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmbeddedDestinationSettings").add("Destination608ChannelNumber", destination608ChannelNumber())
                .add("Destination708ServiceNumber", destination708ServiceNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination608ChannelNumber":
            return Optional.ofNullable(clazz.cast(destination608ChannelNumber()));
        case "Destination708ServiceNumber":
            return Optional.ofNullable(clazz.cast(destination708ServiceNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmbeddedDestinationSettings, T> g) {
        return obj -> g.apply((EmbeddedDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmbeddedDestinationSettings> {
        /**
         * Ignore this setting unless your input captions are SCC format and your output captions are embedded in the
         * video stream. Specify a CC number for each captions channel in this output. If you have two channels, choose
         * CC numbers that aren't in the same field. For example, choose 1 and 3. For more information, see
         * https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
         * 
         * @param destination608ChannelNumber
         *        Ignore this setting unless your input captions are SCC format and your output captions are embedded in
         *        the video stream. Specify a CC number for each captions channel in this output. If you have two
         *        channels, choose CC numbers that aren't in the same field. For example, choose 1 and 3. For more
         *        information, see https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination608ChannelNumber(Integer destination608ChannelNumber);

        /**
         * Ignore this setting unless your input captions are SCC format and you want both 608 and 708 captions embedded
         * in your output stream. Optionally, specify the 708 service number for each output captions channel. Choose a
         * different number for each channel. To use this setting, also set Force 608 to 708 upconvert (Convert608To708)
         * to Upconvert (UPCONVERT) in your input captions selector settings. If you choose to upconvert but don't
         * specify a 708 service number, MediaConvert uses the number that you specify for CC channel number
         * (destination608ChannelNumber) for the 708 service number. For more information, see
         * https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
         * 
         * @param destination708ServiceNumber
         *        Ignore this setting unless your input captions are SCC format and you want both 608 and 708 captions
         *        embedded in your output stream. Optionally, specify the 708 service number for each output captions
         *        channel. Choose a different number for each channel. To use this setting, also set Force 608 to 708
         *        upconvert (Convert608To708) to Upconvert (UPCONVERT) in your input captions selector settings. If you
         *        choose to upconvert but don't specify a 708 service number, MediaConvert uses the number that you
         *        specify for CC channel number (destination608ChannelNumber) for the 708 service number. For more
         *        information, see https://docs.aws.amazon.com/console/mediaconvert/dual-scc-to-embedded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination708ServiceNumber(Integer destination708ServiceNumber);
    }

    static final class BuilderImpl implements Builder {
        private Integer destination608ChannelNumber;

        private Integer destination708ServiceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(EmbeddedDestinationSettings model) {
            destination608ChannelNumber(model.destination608ChannelNumber);
            destination708ServiceNumber(model.destination708ServiceNumber);
        }

        public final Integer getDestination608ChannelNumber() {
            return destination608ChannelNumber;
        }

        public final void setDestination608ChannelNumber(Integer destination608ChannelNumber) {
            this.destination608ChannelNumber = destination608ChannelNumber;
        }

        @Override
        public final Builder destination608ChannelNumber(Integer destination608ChannelNumber) {
            this.destination608ChannelNumber = destination608ChannelNumber;
            return this;
        }

        public final Integer getDestination708ServiceNumber() {
            return destination708ServiceNumber;
        }

        public final void setDestination708ServiceNumber(Integer destination708ServiceNumber) {
            this.destination708ServiceNumber = destination708ServiceNumber;
        }

        @Override
        public final Builder destination708ServiceNumber(Integer destination708ServiceNumber) {
            this.destination708ServiceNumber = destination708ServiceNumber;
            return this;
        }

        @Override
        public EmbeddedDestinationSettings build() {
            return new EmbeddedDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
