/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * This setting can improve the compatibility of your output with video players on obsolete devices. It applies only to
 * DASH H.264 outputs with DRM encryption. Choose Unencrypted SEI (UNENCRYPTED_SEI) only to correct problems with
 * playback on older devices. Otherwise, keep the default setting CENC v1 (CENC_V1). If you choose Unencrypted SEI, for
 * that output, the service will exclude the access unit delimiter and will leave the SEI NAL units unencrypted.
 */
@Generated("software.amazon.awssdk:codegen")
public enum DashIsoPlaybackDeviceCompatibility {
    CENC_V1("CENC_V1"),

    UNENCRYPTED_SEI("UNENCRYPTED_SEI"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DashIsoPlaybackDeviceCompatibility> VALUE_MAP = EnumUtils.uniqueIndex(
            DashIsoPlaybackDeviceCompatibility.class, DashIsoPlaybackDeviceCompatibility::toString);

    private final String value;

    private DashIsoPlaybackDeviceCompatibility(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DashIsoPlaybackDeviceCompatibility corresponding to the value
     */
    public static DashIsoPlaybackDeviceCompatibility fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DashIsoPlaybackDeviceCompatibility}s
     */
    public static Set<DashIsoPlaybackDeviceCompatibility> knownValues() {
        Set<DashIsoPlaybackDeviceCompatibility> knownValues = EnumSet.allOf(DashIsoPlaybackDeviceCompatibility.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
