/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Choose the audio codec for this output. Note that the option Dolby Digital passthrough (PASSTHROUGH) applies only to
 * Dolby Digital and Dolby Digital Plus audio inputs. Make sure that you choose a codec that's supported with your
 * output container:
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/reference-codecs-containers.html#reference-codecs
 * -containers-output-audio For audio-only outputs, make sure that both your input audio codec and your output audio
 * codec are supported for audio-only workflows. For more information, see:
 * https://docs.aws.amazon.com/mediaconvert/latest
 * /ug/reference-codecs-containers-input.html#reference-codecs-containers-input-audio-only and
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/reference-codecs-containers.html#audio-only-output
 */
@Generated("software.amazon.awssdk:codegen")
public enum AudioCodec {
    AAC("AAC"),

    MP2("MP2"),

    MP3("MP3"),

    WAV("WAV"),

    AIFF("AIFF"),

    AC3("AC3"),

    EAC3("EAC3"),

    EAC3_ATMOS("EAC3_ATMOS"),

    VORBIS("VORBIS"),

    OPUS("OPUS"),

    PASSTHROUGH("PASSTHROUGH"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioCodec> VALUE_MAP = EnumUtils.uniqueIndex(AudioCodec.class, AudioCodec::toString);

    private final String value;

    private AudioCodec(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AudioCodec corresponding to the value
     */
    public static AudioCodec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AudioCodec}s
     */
    public static Set<AudioCodec> knownValues() {
        Set<AudioCodec> knownValues = EnumSet.allOf(AudioCodec.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
