/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use Allowed renditions to specify a list of possible resolutions in your ABR stack. * MediaConvert will create an ABR
 * stack exclusively from the list of resolutions that you specify. * Some resolutions in the Allowed renditions list
 * may not be included, however you can force a resolution to be included by setting Required to ENABLED. * You must
 * specify at least one resolution that is greater than or equal to any resolutions that you specify in Min top
 * rendition size or Min bottom rendition size. * If you specify Allowed renditions, you must not specify a separate
 * rule for Force include renditions.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllowedRenditionSize implements SdkPojo, Serializable,
        ToCopyableBuilder<AllowedRenditionSize.Builder, AllowedRenditionSize> {
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(AllowedRenditionSize::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<String> REQUIRED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Required").getter(getter(AllowedRenditionSize::requiredAsString)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Width")
            .getter(getter(AllowedRenditionSize::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEIGHT_FIELD, REQUIRED_FIELD,
            WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer height;

    private final String required;

    private final Integer width;

    private AllowedRenditionSize(BuilderImpl builder) {
        this.height = builder.height;
        this.required = builder.required;
        this.width = builder.width;
    }

    /**
     * Use Height to define the video resolution height, in pixels, for this rule.
     * 
     * @return Use Height to define the video resolution height, in pixels, for this rule.
     */
    public final Integer height() {
        return height;
    }

    /**
     * Set to ENABLED to force a rendition to be included.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #required} will
     * return {@link RequiredFlag#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requiredAsString}.
     * </p>
     * 
     * @return Set to ENABLED to force a rendition to be included.
     * @see RequiredFlag
     */
    public final RequiredFlag required() {
        return RequiredFlag.fromValue(required);
    }

    /**
     * Set to ENABLED to force a rendition to be included.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #required} will
     * return {@link RequiredFlag#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requiredAsString}.
     * </p>
     * 
     * @return Set to ENABLED to force a rendition to be included.
     * @see RequiredFlag
     */
    public final String requiredAsString() {
        return required;
    }

    /**
     * Use Width to define the video resolution width, in pixels, for this rule.
     * 
     * @return Use Width to define the video resolution width, in pixels, for this rule.
     */
    public final Integer width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(requiredAsString());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedRenditionSize)) {
            return false;
        }
        AllowedRenditionSize other = (AllowedRenditionSize) obj;
        return Objects.equals(height(), other.height()) && Objects.equals(requiredAsString(), other.requiredAsString())
                && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllowedRenditionSize").add("Height", height()).add("Required", requiredAsString())
                .add("Width", width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Required":
            return Optional.ofNullable(clazz.cast(requiredAsString()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllowedRenditionSize, T> g) {
        return obj -> g.apply((AllowedRenditionSize) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AllowedRenditionSize> {
        /**
         * Use Height to define the video resolution height, in pixels, for this rule.
         * 
         * @param height
         *        Use Height to define the video resolution height, in pixels, for this rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * Set to ENABLED to force a rendition to be included.
         * 
         * @param required
         *        Set to ENABLED to force a rendition to be included.
         * @see RequiredFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiredFlag
         */
        Builder required(String required);

        /**
         * Set to ENABLED to force a rendition to be included.
         * 
         * @param required
         *        Set to ENABLED to force a rendition to be included.
         * @see RequiredFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequiredFlag
         */
        Builder required(RequiredFlag required);

        /**
         * Use Width to define the video resolution width, in pixels, for this rule.
         * 
         * @param width
         *        Use Width to define the video resolution width, in pixels, for this rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);
    }

    static final class BuilderImpl implements Builder {
        private Integer height;

        private String required;

        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowedRenditionSize model) {
            height(model.height);
            required(model.required);
            width(model.width);
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final String getRequired() {
            return required;
        }

        public final void setRequired(String required) {
            this.required = required;
        }

        @Override
        public final Builder required(String required) {
            this.required = required;
            return this;
        }

        @Override
        public final Builder required(RequiredFlag required) {
            this.required(required == null ? null : required.toString());
            return this;
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        @Override
        public AllowedRenditionSize build() {
            return new AllowedRenditionSize(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
