/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Add texture and detail to areas of your input video content that were lost after applying the Advanced input filter.
 * To adaptively add texture and reduce softness: Choose Enabled. To not add any texture: Keep the default value,
 * Disabled. We recommend that you choose Disabled for input video content that doesn't have texture, including screen
 * recordings, computer graphics, or cartoons.
 */
@Generated("software.amazon.awssdk:codegen")
public enum AdvancedInputFilterAddTexture {
    ENABLED("ENABLED"),

    DISABLED("DISABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdvancedInputFilterAddTexture> VALUE_MAP = EnumUtils.uniqueIndex(
            AdvancedInputFilterAddTexture.class, AdvancedInputFilterAddTexture::toString);

    private final String value;

    private AdvancedInputFilterAddTexture(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AdvancedInputFilterAddTexture corresponding to the value
     */
    public static AdvancedInputFilterAddTexture fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AdvancedInputFilterAddTexture}s
     */
    public static Set<AdvancedInputFilterAddTexture> knownValues() {
        Set<AdvancedInputFilterAddTexture> knownValues = EnumSet.allOf(AdvancedInputFilterAddTexture.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
