/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AudioCodec {
    AAC("AAC"),
    MP2("MP2"),
    MP3("MP3"),
    WAV("WAV"),
    AIFF("AIFF"),
    AC3("AC3"),
    EAC3("EAC3"),
    EAC3_ATMOS("EAC3_ATMOS"),
    VORBIS("VORBIS"),
    OPUS("OPUS"),
    PASSTHROUGH("PASSTHROUGH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioCodec> VALUE_MAP;
    private final String value;

    private AudioCodec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioCodec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioCodec> knownValues() {
        EnumSet<AudioCodec> knownValues = EnumSet.allOf(AudioCodec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AudioCodec.class, AudioCodec::toString);
    }
}

