/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WatermarkingStrength {
    LIGHTEST("LIGHTEST"),
    LIGHTER("LIGHTER"),
    DEFAULT("DEFAULT"),
    STRONGER("STRONGER"),
    STRONGEST("STRONGEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WatermarkingStrength> VALUE_MAP;
    private final String value;

    private WatermarkingStrength(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WatermarkingStrength fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WatermarkingStrength> knownValues() {
        EnumSet<WatermarkingStrength> knownValues = EnumSet.allOf(WatermarkingStrength.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WatermarkingStrength.class, WatermarkingStrength::toString);
    }
}

