/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H264QualityTuningLevel {
    SINGLE_PASS("SINGLE_PASS"),
    SINGLE_PASS_HQ("SINGLE_PASS_HQ"),
    MULTI_PASS_HQ("MULTI_PASS_HQ"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264QualityTuningLevel> VALUE_MAP;
    private final String value;

    private H264QualityTuningLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H264QualityTuningLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H264QualityTuningLevel> knownValues() {
        EnumSet<H264QualityTuningLevel> knownValues = EnumSet.allOf(H264QualityTuningLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H264QualityTuningLevel.class, H264QualityTuningLevel::toString);
    }
}

