/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CaptionDestinationType {
    BURN_IN("BURN_IN"),
    DVB_SUB("DVB_SUB"),
    EMBEDDED("EMBEDDED"),
    EMBEDDED_PLUS_SCTE20("EMBEDDED_PLUS_SCTE20"),
    IMSC("IMSC"),
    SCTE20_PLUS_EMBEDDED("SCTE20_PLUS_EMBEDDED"),
    SCC("SCC"),
    SRT("SRT"),
    SMI("SMI"),
    TELETEXT("TELETEXT"),
    TTML("TTML"),
    WEBVTT("WEBVTT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CaptionDestinationType> VALUE_MAP;
    private final String value;

    private CaptionDestinationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CaptionDestinationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CaptionDestinationType> knownValues() {
        EnumSet<CaptionDestinationType> knownValues = EnumSet.allOf(CaptionDestinationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CaptionDestinationType.class, CaptionDestinationType::toString);
    }
}

