/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HlsEncryptionType {
    AES128("AES128"),
    SAMPLE_AES("SAMPLE_AES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsEncryptionType> VALUE_MAP;
    private final String value;

    private HlsEncryptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsEncryptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsEncryptionType> knownValues() {
        EnumSet<HlsEncryptionType> knownValues = EnumSet.allOf(HlsEncryptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HlsEncryptionType.class, HlsEncryptionType::toString);
    }
}

