/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccelerationMode {
    DISABLED("DISABLED"),
    ENABLED("ENABLED"),
    PREFERRED("PREFERRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccelerationMode> VALUE_MAP;
    private final String value;

    private AccelerationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccelerationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccelerationMode> knownValues() {
        EnumSet<AccelerationMode> knownValues = EnumSet.allOf(AccelerationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccelerationMode.class, AccelerationMode::toString);
    }
}

