/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265Telecine {
    NONE("NONE"),
    SOFT("SOFT"),
    HARD("HARD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265Telecine> VALUE_MAP;
    private final String value;

    private H265Telecine(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265Telecine fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265Telecine> knownValues() {
        EnumSet<H265Telecine> knownValues = EnumSet.allOf(H265Telecine.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265Telecine.class, H265Telecine::toString);
    }
}

