/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265CodecProfile {
    MAIN_MAIN("MAIN_MAIN"),
    MAIN_HIGH("MAIN_HIGH"),
    MAIN10_MAIN("MAIN10_MAIN"),
    MAIN10_HIGH("MAIN10_HIGH"),
    MAIN_422_8_BIT_MAIN("MAIN_422_8BIT_MAIN"),
    MAIN_422_8_BIT_HIGH("MAIN_422_8BIT_HIGH"),
    MAIN_422_10_BIT_MAIN("MAIN_422_10BIT_MAIN"),
    MAIN_422_10_BIT_HIGH("MAIN_422_10BIT_HIGH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265CodecProfile> VALUE_MAP;
    private final String value;

    private H265CodecProfile(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265CodecProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265CodecProfile> knownValues() {
        EnumSet<H265CodecProfile> knownValues = EnumSet.allOf(H265CodecProfile.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265CodecProfile.class, H265CodecProfile::toString);
    }
}

