/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.ImscAccessibilitySubs;
import software.amazon.awssdk.services.mediaconvert.model.ImscStylePassthrough;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImscDestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImscDestinationSettings> {
    private static final SdkField<String> ACCESSIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Accessibility").getter(ImscDestinationSettings.getter(ImscDestinationSettings::accessibilityAsString)).setter(ImscDestinationSettings.setter(Builder::accessibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessibility").build()}).build();
    private static final SdkField<String> STYLE_PASSTHROUGH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StylePassthrough").getter(ImscDestinationSettings.getter(ImscDestinationSettings::stylePassthroughAsString)).setter(ImscDestinationSettings.setter(Builder::stylePassthrough)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stylePassthrough").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSIBILITY_FIELD, STYLE_PASSTHROUGH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessibility;
    private final String stylePassthrough;

    private ImscDestinationSettings(BuilderImpl builder) {
        this.accessibility = builder.accessibility;
        this.stylePassthrough = builder.stylePassthrough;
    }

    public final ImscAccessibilitySubs accessibility() {
        return ImscAccessibilitySubs.fromValue(this.accessibility);
    }

    public final String accessibilityAsString() {
        return this.accessibility;
    }

    public final ImscStylePassthrough stylePassthrough() {
        return ImscStylePassthrough.fromValue(this.stylePassthrough);
    }

    public final String stylePassthroughAsString() {
        return this.stylePassthrough;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stylePassthroughAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImscDestinationSettings)) {
            return false;
        }
        ImscDestinationSettings other = (ImscDestinationSettings)obj;
        return Objects.equals(this.accessibilityAsString(), other.accessibilityAsString()) && Objects.equals(this.stylePassthroughAsString(), other.stylePassthroughAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImscDestinationSettings").add("Accessibility", (Object)this.accessibilityAsString()).add("StylePassthrough", (Object)this.stylePassthroughAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Accessibility": {
                return Optional.ofNullable(clazz.cast(this.accessibilityAsString()));
            }
            case "StylePassthrough": {
                return Optional.ofNullable(clazz.cast(this.stylePassthroughAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImscDestinationSettings, T> g) {
        return obj -> g.apply((ImscDestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessibility;
        private String stylePassthrough;

        private BuilderImpl() {
        }

        private BuilderImpl(ImscDestinationSettings model) {
            this.accessibility(model.accessibility);
            this.stylePassthrough(model.stylePassthrough);
        }

        public final String getAccessibility() {
            return this.accessibility;
        }

        public final void setAccessibility(String accessibility) {
            this.accessibility = accessibility;
        }

        @Override
        @Transient
        public final Builder accessibility(String accessibility) {
            this.accessibility = accessibility;
            return this;
        }

        @Override
        @Transient
        public final Builder accessibility(ImscAccessibilitySubs accessibility) {
            this.accessibility(accessibility == null ? null : accessibility.toString());
            return this;
        }

        public final String getStylePassthrough() {
            return this.stylePassthrough;
        }

        public final void setStylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
        }

        @Override
        @Transient
        public final Builder stylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
            return this;
        }

        @Override
        @Transient
        public final Builder stylePassthrough(ImscStylePassthrough stylePassthrough) {
            this.stylePassthrough(stylePassthrough == null ? null : stylePassthrough.toString());
            return this;
        }

        public ImscDestinationSettings build() {
            return new ImscDestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImscDestinationSettings> {
        public Builder accessibility(String var1);

        public Builder accessibility(ImscAccessibilitySubs var1);

        public Builder stylePassthrough(String var1);

        public Builder stylePassthrough(ImscStylePassthrough var1);
    }
}

